/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import cern.jet.stat.Gamma;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;

public class LinearModelUtils {
    private LinearModelUtils() {
    }

    public static double Ftest(double F, double numeratordf, double denominatordf) {
        double k = denominatordf / (denominatordf + numeratordf * F);
        return Gamma.incompleteBeta((double)(denominatordf / 2.0), (double)(numeratordf / 2.0), (double)k);
    }

    public static DoubleMatrix createFixedEffectsArray(ArrayList<String[]> factorList, ArrayList<double[]> covariateList, boolean[] missing) {
        int i;
        int numberOfFactors = factorList == null ? 0 : factorList.size();
        int numberOfCovariates = covariateList == null ? 0 : covariateList.size();
        int numberOfEffects = 1 + numberOfFactors + numberOfCovariates;
        DoubleMatrix[][] theMatrices = new DoubleMatrix[1][numberOfEffects];
        int numberOfObs = 0;
        for (boolean m : missing) {
            if (m) continue;
            ++numberOfObs;
        }
        int count = 0;
        theMatrices[0][count++] = DoubleMatrixFactory.DEFAULT.make(numberOfObs, 1, 1.0);
        for (i = 0; i < numberOfFactors; ++i) {
            String[] nonMissingFactorLevels = (String[])LinearModelUtils.getNonMissingElements((Object[])factorList.get(i), missing);
            int[] levels = ModelEffectUtils.getIntegerLevels(nonMissingFactorLevels, null);
            FactorModelEffect fme = new FactorModelEffect(levels, true);
            theMatrices[0][count++] = fme.getX();
        }
        for (i = 0; i < numberOfCovariates; ++i) {
            double[] nonMissingValues = LinearModelUtils.getNonMissingElements(covariateList.get(i), missing);
            theMatrices[0][count++] = DoubleMatrixFactory.DEFAULT.make(numberOfObs, 1, nonMissingValues);
        }
        if (theMatrices[0].length == 1) {
            return theMatrices[0][0];
        }
        return DoubleMatrixFactory.DEFAULT.compose(theMatrices);
    }

    public static <T> T[] getNonMissingElements(T[] array, boolean[] missing) {
        int numberNotMissing = 0;
        for (boolean m : missing) {
            if (m) continue;
            ++numberNotMissing;
        }
        T[] reducedArray = Arrays.copyOf(array, numberNotMissing);
        int n = array.length;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (missing[i]) continue;
            reducedArray[count++] = array[i];
        }
        return reducedArray;
    }

    public static double[] getNonMissingElements(double[] array, boolean[] missing) {
        int numberNotMissing = 0;
        for (boolean m : missing) {
            if (m) continue;
            ++numberNotMissing;
        }
        double[] reducedArray = new double[numberNotMissing++];
        int n = array.length;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (missing[i]) continue;
            reducedArray[count++] = array[i];
        }
        return reducedArray;
    }

    public static void shuffle(double[] source, Random randomizer) {
        int n = source.length;
        for (int i = n - 1; i > 0; --i) {
            int j = randomizer.nextInt(i + 1);
            double k = source[j];
            source[j] = source[i];
            source[i] = k;
        }
    }
}

