/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;

public class ModelEffectUtils {
    private ModelEffectUtils() {
    }

    public static DoubleMatrix getXtY(ModelEffect X, ModelEffect Y) {
        if (X instanceof FactorModelEffect) {
            FactorModelEffect fme = (FactorModelEffect)X;
            if (Y instanceof FactorModelEffect) {
                return fme.getXtX2((FactorModelEffect)Y);
            }
            if (Y instanceof CovariateModelEffect) {
                return fme.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return fme.getX().mult(Y.getX(), true, false);
            }
        } else if (X instanceof CovariateModelEffect) {
            double[] cov = ((CovariateModelEffect)X).getCovariate();
            if (Y instanceof FactorModelEffect) {
                return ModelEffectUtils.getXtY(Y, X).transpose();
            }
            if (Y instanceof CovariateModelEffect) {
                return Y.getXty(cov);
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return Y.getXty(cov).transpose();
            }
        } else if (X instanceof NestedCovariateModelEffect) {
            if (Y instanceof FactorModelEffect) {
                return X.getX().mult(Y.getX(), true, false);
            }
            if (Y instanceof CovariateModelEffect) {
                return X.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return ((NestedCovariateModelEffect)X).getXtX2((NestedCovariateModelEffect)Y);
            }
        }
        return null;
    }

    public static int[] getIntegerLevels(Object[] originalLevels) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<Object, Integer> levelMap = new HashMap<Object, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(T[] originalLevels, ArrayList<T> ids) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels, ArrayList<T> ids) {
        int[] intLevels = new int[originalLevels.size()];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        int count = 0;
        for (T level : originalLevels) {
            void var7_7;
            Integer n = (Integer)levelMap.get(level);
            if (n == null) {
                Integer n2 = new Integer(levelMap.size());
                levelMap.put(level, n2);
            }
            intLevels[count++] = var7_7.intValue();
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels) {
        return ModelEffectUtils.getIntegerLevels(originalLevels, null);
    }
}

