/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;

public class WithinPopulationPermuter {
    final double[] data;
    final int npops;
    ArrayList<int[]> popIndices = new ArrayList();
    static Random randomizer = new Random();

    public WithinPopulationPermuter(double[] originalData, FactorModelEffect popEffect) {
        this.data = originalData;
        this.npops = popEffect.getNumberOfLevels();
        int[] levels = popEffect.getLevels();
        int[] levelCounts = popEffect.getLevelCounts();
        for (int p = 0; p < this.npops; ++p) {
            this.popIndices.add(new int[levelCounts[p]]);
        }
        int[] count = new int[this.npops];
        int n = levels.length;
        int i = 0;
        while (i < n) {
            int pop;
            int n2 = pop = levels[i];
            int n3 = count[n2];
            count[n2] = n3 + 1;
            this.popIndices.get((int)pop)[n3] = i++;
        }
    }

    public double[] getPermutedData() {
        int ndata = this.data.length;
        double[] permutedData = Arrays.copyOf(this.data, ndata);
        for (int p = 0; p < this.npops; ++p) {
            int[] ndx = this.popIndices.get(p);
            int n = ndx.length;
            for (int i = n - 1; i >= 1; --i) {
                int j = randomizer.nextInt(i + 1);
                double temp = permutedData[ndx[j]];
                permutedData[ndx[j]] = permutedData[ndx[i]];
                permutedData[ndx[i]] = temp;
            }
        }
        return permutedData;
    }

    public void permuteData(double[] data) {
        int ndata = data.length;
        for (int p = 0; p < this.npops; ++p) {
            int[] ndx = this.popIndices.get(p);
            int n = ndx.length;
            for (int i = n - 1; i >= 1; --i) {
                int j = randomizer.nextInt(i + 1);
                double temp = data[ndx[j]];
                data[ndx[j]] = data[ndx[i]];
                data[ndx[i]] = temp;
            }
        }
    }
}

