/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.statistics;

import net.maizegenetics.stats.math.MersenneTwisterFast;

public class ContigencyTable {
    MersenneTwisterFast intRand = new MersenneTwisterFast();
    int[][] contig;
    int csum;
    int rows;
    int cols;
    int[] crow;
    int[] ccol;
    int[] rowDist;
    int[] colDist;
    float[][] expectation;
    private double[] f;
    double mcF;
    int maxSize;

    public ContigencyTable(int maxSize) {
        this.maxSize = 2 * maxSize;
        this.f = new double[this.maxSize + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
    }

    public void setMatrix(int[][] tcontig) {
        int j;
        int i;
        int count = 0;
        this.rows = tcontig.length;
        this.cols = tcontig[0].length;
        this.contig = tcontig;
        this.csum = 0;
        this.crow = new int[this.rows];
        this.ccol = new int[this.cols];
        for (i = 0; i < this.rows; ++i) {
            for (j = 0; j < this.cols; ++j) {
                this.csum += this.contig[i][j];
                int n = i;
                this.crow[n] = this.crow[n] + this.contig[i][j];
                int n2 = j;
                this.ccol[n2] = this.ccol[n2] + this.contig[i][j];
            }
        }
        if (this.csum > 1000) {
            // empty if block
        }
        if (this.csum > this.maxSize) {
            this.contig = null;
            return;
        }
        this.rowDist = new int[this.csum];
        this.colDist = new int[this.csum];
        for (i = 0; i < this.rows; ++i) {
            for (j = 0; j < this.cols; ++j) {
                for (int k = 0; k < this.contig[i][j]; ++k) {
                    this.rowDist[count] = i;
                    this.colDist[count] = j;
                    ++count;
                }
            }
        }
        if (this.maxSize > 0) {
            this.mcF = 0.0;
            for (i = 0; i < this.rows; ++i) {
                this.mcF += this.f[this.crow[i]];
            }
            for (j = 0; j < this.cols; ++j) {
                this.mcF += this.f[this.ccol[j]];
            }
            this.mcF -= this.f[2 * this.csum];
        }
    }

    final float calcchiSquare() {
        float chi = 0.0f;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.contig[i][j] <= 0) continue;
                float E = this.expectation[i][j];
                chi += ((float)this.contig[i][j] - E) * ((float)this.contig[i][j] - E) / E;
            }
        }
        return chi;
    }

    final double calcLnFisherExactP() {
        double lnFisherExactP = this.mcF;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                lnFisherExactP -= this.f[this.contig[i][j]];
            }
        }
        return lnFisherExactP;
    }

    final void randomcontig() {
        int i;
        for (i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.contig[i][j] = 0;
            }
        }
        for (i = 0; i < this.csum; ++i) {
            int r = this.intRand.nextInt(this.csum);
            int temp = this.rowDist[i];
            this.rowDist[i] = this.rowDist[r];
            this.rowDist[r] = temp;
        }
        for (i = 0; i < this.csum; ++i) {
            int[] nArray = this.contig[this.rowDist[i]];
            int n = this.colDist[i];
            nArray[n] = nArray[n] + 1;
        }
    }

    public double calcRapidContigencyChiSquare(int maxPermutations) {
        int r;
        int reps = maxPermutations;
        double chiprob = 0.0;
        double Origchi = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        for (r = 0; r <= reps; ++r) {
            if (r > 0) {
                this.randomcontig();
            }
            double X = this.calcchiSquare();
            if (r == 0) {
                Origchi = X;
            } else if (X >= Origchi) {
                chiprob += 1.0;
            }
            if (!(chiprob > 9.0)) continue;
            reps = r - 1;
        }
        return chiprob / (double)r;
    }

    public double calcContigencyChiSquare(int permutations) {
        int r;
        double chiprob = 0.0;
        double Origchi = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        for (r = 0; r <= permutations; ++r) {
            if (r > 0) {
                this.randomcontig();
            }
            double X = this.calcchiSquare();
            if (r == 0) {
                Origchi = X;
                continue;
            }
            if (!(X >= Origchi)) continue;
            chiprob += 1.0;
        }
        return chiprob / (double)r;
    }

    public double calcRapidMonteCarloExactTest(int maxPermutations) {
        int r;
        int reps = maxPermutations;
        double mCFEprob = 0.0;
        double origMCFE = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        for (r = 0; r <= reps; ++r) {
            if (r > 0) {
                this.randomcontig();
            }
            double fE = this.calcLnFisherExactP();
            if (r == 0) {
                origMCFE = fE;
            } else if (fE <= origMCFE) {
                mCFEprob += 1.0;
            }
            if (!(mCFEprob > 9.0)) continue;
            reps = r - 1;
        }
        return mCFEprob / (double)r;
    }

    public double calcMonteCarloExactTest(int permutations) {
        int r;
        double mCFEprob = 0.0;
        double origMCFE = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        for (r = 0; r <= permutations; ++r) {
            if (r > 0) {
                this.randomcontig();
            }
            double fE = this.calcLnFisherExactP();
            if (r == 0) {
                origMCFE = fE;
                continue;
            }
            if (!(fE <= origMCFE)) continue;
            mCFEprob += 1.0;
        }
        return mCFEprob / (double)r;
    }

    void writeMatrix() {
        for (int i = 0; i < this.rows; ++i) {
            System.out.print("r" + i + "   ");
            for (int j = 0; j < this.cols; ++j) {
                System.out.print(this.contig[i][j] + "  ");
            }
            System.out.println();
        }
    }
}

