/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpDialog
extends JDialog {
    private JEditorPane htmlPane = new JEditorPane();

    public HelpDialog(Frame frame) {
        super(frame, "TASSEL Help", false);
        this.htmlPane.setEditable(false);
        this.initHelp();
        JScrollPane htmlView = new JScrollPane(this.htmlPane);
        Dimension minimumSize = new Dimension(400, 400);
        htmlView.setMinimumSize(minimumSize);
        htmlView.setPreferredSize(new Dimension(600, 400));
        this.getContentPane().add((Component)htmlView, "Center");
        this.pack();
    }

    private void initHelp() {
        String s = "Home.html";
        try {
            this.displayURL(s);
        }
        catch (Exception e) {
            System.err.println("Couldn't create net.maizegenetics.help URL: " + s);
        }
    }

    private void displayURL(String url) {
        try {
            this.htmlPane.setPage(HelpDialog.class.getResource(url));
            this.htmlPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
                    URL url = hyperlinkEvent.getURL();
                    if (type == HyperlinkEvent.EventType.ENTERED) {
                        System.out.println("URL: " + url);
                    } else if (type == HyperlinkEvent.EventType.ACTIVATED) {
                        System.out.println("Activated");
                        try {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                        }
                        catch (Exception er) {
                            er.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + url);
        }
    }
}

