/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import java.io.Serializable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;

public class DistanceMatrixUtils
implements Serializable {
    public static double squaredDistance(DistanceMatrix mat1, DistanceMatrix mat2, boolean weighted) {
        int i;
        boolean aliasNeeded = false;
        if (mat1.getSize() != mat2.getSize()) {
            aliasNeeded = true;
        }
        int[] alias = null;
        if (aliasNeeded) {
            if (mat1.getSize() > mat2.getSize()) {
                DistanceMatrix temp = mat2;
                mat2 = mat1;
                mat1 = temp;
            }
            alias = new int[mat1.getSize()];
            for (i = 0; i < alias.length; ++i) {
                alias[i] = mat2.whichIdNumber(mat1.getTaxon(i).getName());
            }
        } else {
            alias = new int[mat1.getSize()];
            for (i = 0; i < alias.length; ++i) {
                alias[i] = i;
            }
        }
        double sum = 0.0;
        double[][] mat1Distance = mat1.getDistances();
        double[][] mat2Distance = mat2.getDistances();
        for (int i2 = 0; i2 < mat1.getSize() - 1; ++i2) {
            int ai = alias[i2];
            for (int j = i2 + 1; j < mat1.getSize(); ++j) {
                double diff = mat1Distance[i2][j] - mat2Distance[ai][alias[j]];
                double weight = weighted ? 1.0 / (mat1Distance[i2][j] * mat2Distance[ai][alias[j]]) : 1.0;
                sum += weight * diff * diff;
            }
        }
        return 2.0 * sum;
    }

    public static DistanceMatrix minus(DistanceMatrix parent, int taxaToRemove) {
        int size = parent.numberOfTaxa() - 1;
        double[][] distances = new double[size][size];
        Taxon[] ids = new Taxon[size];
        int counti = 0;
        int countj = 0;
        for (int i = 0; i < size; ++i) {
            if (counti == taxaToRemove) {
                ++counti;
            }
            ids[i] = parent.getTaxon(counti);
            countj = 0;
            double[][] parentDistance = parent.getDistances();
            for (int j = 0; j < size; ++j) {
                if (countj == taxaToRemove) {
                    ++countj;
                }
                distances[i][j] = parentDistance[counti][countj];
                ++countj;
            }
            ++counti;
        }
        TaxaList tl = new TaxaListBuilder().addAll(ids).build();
        DistanceMatrix smaller = new DistanceMatrix(distances, tl);
        return smaller;
    }

    public static double getIBSDistance(long[] iMajor, long[] iMinor, long[] jMajor, long[] jMinor) {
        int sameCnt = 0;
        int diffCnt = 0;
        int hetCnt = 0;
        for (int x = 0; x < iMajor.length; ++x) {
            long same = iMajor[x] & jMajor[x] | iMinor[x] & jMinor[x];
            long diff = iMajor[x] & jMinor[x] | iMinor[x] & jMajor[x];
            long hets = same & diff;
            sameCnt += BitUtil.pop(same);
            diffCnt += BitUtil.pop(diff);
            hetCnt += BitUtil.pop(hets);
        }
        double identity = (double)(sameCnt + hetCnt / 2) / (double)(sameCnt + diffCnt + hetCnt);
        double dist = 1.0 - identity;
        return dist;
    }

    public static double getIBSDistance(BitSet iMajor, BitSet iMinor, BitSet jMajor, BitSet jMinor) {
        return DistanceMatrixUtils.getIBSDistance(iMajor.getBits(), iMinor.getBits(), jMajor.getBits(), jMinor.getBits());
    }
}

