/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.SplitUtils;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.taxa.tree.TreeUtils;

public class CladeSystem {
    private TaxaList idGroup;
    private boolean[][] clades;

    public CladeSystem(TaxaList idGroup, int size) {
        this.idGroup = idGroup;
        this.clades = new boolean[size][idGroup.numberOfTaxa()];
    }

    public int getCladeCount() {
        return this.clades.length;
    }

    public int getLabelCount() {
        return this.clades[0].length;
    }

    public boolean[][] getCladeArray() {
        return this.clades;
    }

    public boolean[] getClade(int i) {
        return this.clades[i];
    }

    public TaxaList getIdGroup() {
        return this.idGroup;
    }

    public boolean hasClade(boolean[] clade) {
        for (int i = 0; i < this.clades.length; ++i) {
            if (!SplitUtils.isSame(clade, this.clades[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (i = 0; i < this.getLabelCount(); ++i) {
            pw.println(this.idGroup.taxaName(i));
        }
        pw.println();
        for (i = 0; i < this.getCladeCount(); ++i) {
            for (int j = 0; j < this.getLabelCount(); ++j) {
                if (this.clades[i][j]) {
                    pw.print('*');
                    continue;
                }
                pw.print('.');
            }
            pw.println();
        }
        return sw.toString();
    }

    public static CladeSystem[] getCladeSystems(Tree[] trees) {
        TaxaList idGroup = TreeUtils.getLeafIdGroup(trees[0]);
        CladeSystem[] cladeSystems = new CladeSystem[trees.length];
        for (int i = 0; i < cladeSystems.length; ++i) {
            cladeSystems[i] = CladeSystem.getClades(idGroup, trees[i]);
        }
        return cladeSystems;
    }

    public static void calculateCladeProbabilities(Tree tree, CladeSystem[] cladeSystems) {
        CladeSystem cladeSystem = CladeSystem.getClades(cladeSystems[0].getIdGroup(), tree);
        for (int i = 0; i < tree.getInternalNodeCount() - 1; ++i) {
            Node node = tree.getInternalNode(i);
            boolean[] clade = cladeSystem.getClade(i);
            if (node.isRoot()) {
                throw new RuntimeException("Root node does not have clade probability!");
            }
            int cladeCount = 0;
            for (int j = 0; j < cladeSystems.length; ++j) {
                if (!cladeSystems[j].hasClade(clade)) continue;
                ++cladeCount;
            }
            double pr = (double)cladeCount / (double)cladeSystems.length;
            tree.setAttribute(node, "clade probability", new Double(pr));
        }
    }

    public static CladeSystem getClades(TaxaList idGroup, Tree tree) {
        tree.createNodeList();
        int size = tree.getInternalNodeCount() - 1;
        CladeSystem cladeSystem = new CladeSystem(idGroup, size);
        boolean[][] clades = cladeSystem.getCladeArray();
        for (int i = 0; i < size; ++i) {
            CladeSystem.getClade(idGroup, tree.getInternalNode(i), clades[i]);
        }
        return cladeSystem;
    }

    public static CladeSystem getClades(Tree tree) {
        TaxaList idGroup = TreeUtils.getLeafIdGroup(tree);
        return CladeSystem.getClades(idGroup, tree);
    }

    public static void getClade(TaxaList idGroup, Node internalNode, boolean[] clade) {
        if (internalNode.isLeaf() || internalNode.isRoot()) {
            throw new IllegalArgumentException("Only internal nodes (and no root) nodes allowed");
        }
        for (int i = 0; i < clade.length; ++i) {
            clade[i] = false;
        }
        SplitUtils.markNode(idGroup, internalNode, clade);
    }

    public static boolean isSame(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Clades must be of the same length!");
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }
}

