/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.maizegenetics.stats.math.OrthogonalHints;
import net.maizegenetics.taxa.tree.Parameterized;
import net.maizegenetics.taxa.tree.Units;
import net.maizegenetics.util.FormattedOutput;
import net.maizegenetics.util.Report;

public abstract class MutationRateModel
implements Units,
Parameterized,
Report,
Cloneable,
Serializable {
    protected FormattedOutput fo;
    private int units;
    private double maximumMutationRate_;
    private static final long serialVersionUID = -1755051453782951214L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.units);
        out.writeDouble(this.maximumMutationRate_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.units = in.readInt();
        this.maximumMutationRate_ = in.readDouble();
        this.fo = FormattedOutput.getInstance();
    }

    protected MutationRateModel(int units, double maximumMutationRate) {
        this.setUnits(units, maximumMutationRate);
        this.fo = FormattedOutput.getInstance();
    }

    protected MutationRateModel(MutationRateModel toCopy) {
        this.units = toCopy.units;
        this.maximumMutationRate_ = toCopy.maximumMutationRate_;
        this.fo = FormattedOutput.getInstance();
    }

    public abstract Object clone();

    public abstract MutationRateModel getCopy();

    public abstract double getMutationRate(double var1);

    public abstract double getExpectedSubstitutions(double var1);

    public double getTime(double expectedSubs) {
        return this.getEndTime(expectedSubs, 0.0);
    }

    public abstract double getEndTime(double var1, double var3);

    public abstract void scale(double var1);

    public double getExpectedSubstitutions(double start, double finish) {
        return this.getExpectedSubstitutions(finish) - this.getExpectedSubstitutions(start);
    }

    public final void setUnits(int u, double maximumMutationRate) {
        if (u == 0) {
            throw new IllegalArgumentException("Units cannot be Expected Substitutions!");
        }
        this.units = u;
        this.maximumMutationRate_ = maximumMutationRate;
    }

    protected final double getMaximumMutationRate() {
        return this.maximumMutationRate_;
    }

    public int getUnits() {
        return this.units;
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public abstract String toSingleLine();

    public abstract Factory generateFactory();

    public static interface Factory {
        public MutationRateModel generateNewModel();
    }
}

