/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Hashtable;
import net.maizegenetics.taxa.IdGroupUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.AttributeNode;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeUtils;
import net.maizegenetics.taxa.tree.TreeUtils;
import net.maizegenetics.taxa.tree.Units;
import net.maizegenetics.taxa.tree.UnitsProvider;
import net.maizegenetics.util.Report;

public interface Tree
extends Units,
Serializable,
UnitsProvider {
    public Node getRoot();

    public void setRoot(Node var1);

    public int getExternalNodeCount();

    public int getInternalNodeCount();

    public Node getExternalNode(int var1);

    public Node getInternalNode(int var1);

    public void createNodeList();

    @Override
    public int getUnits();

    public int getIdCount();

    public Taxon getIdentifier(int var1);

    public int whichIdNumber(String var1);

    public int whichIdNumber(Taxon var1);

    public void setAttribute(Node var1, String var2, Object var3);

    public Object getAttribute(Node var1, String var2);

    public Tree getCopy();

    public static abstract class TreeBase
    implements Tree,
    Report,
    Units,
    Serializable {
        private Node root;
        private Node[] internalNode = null;
        private int numInternalNodes;
        private Node[] externalNode = null;
        private int numExternalNodes;
        private Hashtable[] attributes = null;
        private int units = 0;
        private boolean setupLengthsAndHeights_ = true;
        private TaxaList myTaxaList;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(2);
            out.writeObject(this.root);
            out.writeObject(this.attributes);
            out.writeInt(this.units);
            out.writeBoolean(this.setupLengthsAndHeights_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 1: {
                    this.root = (Node)in.readObject();
                    this.createNodeList();
                    this.attributes = (Hashtable[])in.readObject();
                    this.units = in.readInt();
                }
            }
            this.root = (Node)in.readObject();
            this.createNodeList();
            this.attributes = (Hashtable[])in.readObject();
            this.units = in.readInt();
            this.setupLengthsAndHeights_ = in.readBoolean();
        }

        protected TreeBase(Node theRoot) {
            this.setRoot(theRoot);
        }

        protected TreeBase() {
        }

        protected TreeBase(TreeBase tree, Node newRoot) {
            this.setRoot(newRoot);
            this.setUnits(tree.getUnits());
        }

        @Override
        public void setRoot(Node theRoot) {
            this.root = theRoot;
            this.createNodeList();
        }

        @Override
        public final int getUnits() {
            return this.units;
        }

        public final void setUnits(int units) {
            this.units = units;
        }

        @Override
        public final int getExternalNodeCount() {
            if (this.externalNode == null) {
                this.createNodeList();
            }
            return this.numExternalNodes;
        }

        @Override
        public final Node getExternalNode(int i) {
            if (this.externalNode == null) {
                this.createNodeList();
            }
            return this.externalNode[i];
        }

        @Override
        public final int getInternalNodeCount() {
            if (this.internalNode == null) {
                this.createNodeList();
            }
            return this.numInternalNodes;
        }

        @Override
        public final Node getInternalNode(int i) {
            if (this.internalNode == null) {
                this.createNodeList();
            }
            return this.internalNode[i];
        }

        @Override
        public final Node getRoot() {
            return this.root;
        }

        public Node findNode(int num) {
            this.createNodeList();
            if (num <= this.numExternalNodes) {
                return this.externalNode[num - 1];
            }
            return this.internalNode[num - 1 - this.numExternalNodes];
        }

        @Override
        public void createNodeList() {
            this.numInternalNodes = 0;
            this.numExternalNodes = 0;
            Node node = this.root;
            do {
                if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                    node.setNumber(this.numExternalNodes);
                    ++this.numExternalNodes;
                    continue;
                }
                node.setNumber(this.numInternalNodes);
                ++this.numInternalNodes;
            } while (node != this.root);
            this.internalNode = new Node[this.numInternalNodes];
            this.externalNode = new Node[this.numExternalNodes];
            node = this.root;
            do {
                if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                    this.externalNode[node.getNumber()] = node;
                    continue;
                }
                this.internalNode[node.getNumber()] = node;
            } while (node != this.root);
            if (this.setupLengthsAndHeights_ && this.root.getNodeHeight() == 0.0) {
                NodeUtils.lengths2Heights(this.root);
            }
        }

        private int getIndex(Node node) {
            if (node.isLeaf()) {
                return node.getNumber();
            }
            return this.getExternalNodeCount() + node.getNumber();
        }

        protected void setSetupLengthsAndHeights(boolean value) {
            this.setupLengthsAndHeights_ = value;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            NodeUtils.printNH(new PrintWriter(sw), this.getRoot(), true, false, 0, false);
            sw.write(";");
            return sw.toString();
        }

        @Override
        public void setAttribute(Node node, String name, Object value) {
            if (node instanceof AttributeNode) {
                ((AttributeNode)node).setAttribute(name, value);
            } else {
                int index = this.getIndex(node);
                if (this.attributes == null) {
                    this.attributes = new Hashtable[this.getExternalNodeCount() + this.getInternalNodeCount()];
                }
                if (this.attributes[index] == null) {
                    this.attributes[index] = new Hashtable();
                }
                this.attributes[index].put(name, value);
            }
        }

        @Override
        public Object getAttribute(Node node, String name) {
            if (node instanceof AttributeNode) {
                return ((AttributeNode)node).getAttribute(name);
            }
            int index = this.getIndex(node);
            if (this.attributes == null || this.attributes[index] == null) {
                return null;
            }
            return this.attributes[index].get(name);
        }

        public void reroot(int num) {
            TreeUtils.reroot(this, this.findNode(num));
        }

        public void reroot(Node node) {
            TreeUtils.reroot(this, node);
        }

        @Override
        public int getIdCount() {
            return this.getExternalNodeCount();
        }

        @Override
        public Taxon getIdentifier(int i) {
            return this.getExternalNode(i).getIdentifier();
        }

        public void setIdentifier(int i, Taxon id) {
            this.getExternalNode(i).setIdentifier(id);
        }

        @Override
        public int whichIdNumber(String s) {
            return IdGroupUtils.whichIdNumber(this.myTaxaList, s);
        }

        @Override
        public void report(PrintWriter out) {
            TreeUtils.report(this, out);
        }
    }
}

