/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.AbstractPhenotype;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;

public class CombinePhenotype
extends AbstractPhenotype {
    Phenotype[] phenotypes;
    int numberOfPhenotypes;
    boolean isUnion;
    int[][] phenotypeColumn;
    int[][] phenotypeRow;
    int totalColumns;
    int totalRows;

    private CombinePhenotype(Phenotype[] phenotypes, boolean isUnion, TaxaList taxaGroup, List<Trait> traitList, int[][] rowmap, int[][] columnmap) {
        super(taxaGroup, traitList);
        this.phenotypes = phenotypes;
        this.isUnion = isUnion;
        this.phenotypeRow = rowmap;
        this.phenotypeColumn = columnmap;
        this.totalColumns = this.phenotypeColumn.length;
        this.totalRows = this.phenotypeRow.length;
    }

    public static CombinePhenotype getInstance(Phenotype phenotype1, Phenotype phenotype2, boolean isUnion) {
        return CombinePhenotype.getInstance(new Phenotype[]{phenotype1, phenotype2}, isUnion);
    }

    public static CombinePhenotype getInstance(Phenotype[] phenotypes, boolean isUnion) {
        Object[] rowinfo = CombinePhenotype.mapRows(phenotypes, isUnion);
        Object[] colinfo = CombinePhenotype.mapColumns(phenotypes, isUnion);
        int[][] rowmap = (int[][])rowinfo[0];
        TaxaList taxa = (TaxaList)rowinfo[1];
        int[][] colmap = (int[][])colinfo[0];
        ArrayList traitList = (ArrayList)colinfo[1];
        return new CombinePhenotype(phenotypes, isUnion, taxa, traitList, rowmap, colmap);
    }

    private static Object[] mapRows(Phenotype[] phenotypes, boolean isUnion) {
        TreeMap<Taxon, int[]> rowTreeMap = new TreeMap<Taxon, int[]>();
        int npheno = phenotypes.length;
        int pcount = 0;
        for (Phenotype pheno : phenotypes) {
            int n = pheno.getNumberOfTaxa();
            int t = 0;
            while (t < n) {
                Taxon id = pheno.getTaxon(t);
                int[] rows = (int[])rowTreeMap.get(id);
                if (rows == null) {
                    rows = new int[npheno];
                    for (int i = 0; i < npheno; ++i) {
                        rows[i] = -1;
                    }
                    rowTreeMap.put(id, rows);
                }
                rows[pcount] = t++;
            }
            ++pcount;
        }
        Set rowSet = rowTreeMap.entrySet();
        if (!isUnion) {
            Iterator rit = rowSet.iterator();
            while (rit.hasNext()) {
                int[] rows;
                boolean notComplete = false;
                for (int i : rows = (int[])rit.next().getValue()) {
                    if (i != -1) continue;
                    notComplete = true;
                    break;
                }
                if (!notComplete) continue;
                rit.remove();
            }
        }
        int nrows = rowSet.size();
        int[][] rowmap = new int[nrows][];
        Taxon[] ids = new Taxon[nrows];
        int count = 0;
        for (Map.Entry entry : rowSet) {
            rowmap[count] = (int[])entry.getValue();
            ids[count] = (Taxon)entry.getKey();
            ++count;
        }
        TaxaList tl = new TaxaListBuilder().addAll(ids).build();
        return new Object[]{rowmap, tl};
    }

    private static Object[] mapColumns(Phenotype[] phenotypes, boolean isUnion) {
        int ncol = 0;
        for (Phenotype pheno : phenotypes) {
            ncol += pheno.getNumberOfTraits();
        }
        ArrayList<Trait> traitList = new ArrayList<Trait>(ncol);
        int[][] colmap = new int[ncol][2];
        int count1 = 0;
        int count2 = 0;
        for (Phenotype pheno : phenotypes) {
            int n = pheno.getNumberOfTraits();
            for (int i = 0; i < n; ++i) {
                colmap[count2][0] = count1;
                colmap[count2][1] = i;
                ++count2;
                traitList.add(Trait.getInstance(pheno.getTrait(i)));
            }
            ++count1;
        }
        return new Object[]{colmap, traitList};
    }

    @Override
    public double[][] getData() {
        int nrows = this.getNumberOfTraits();
        int ncols = this.getNumberOfTraits();
        double[][] result = new double[nrows][ncols];
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                result[r][c] = this.getData(r, c);
            }
        }
        return null;
    }

    @Override
    public double getData(Taxon taxon, Trait trait) {
        return this.getData(this.whichTaxon(taxon), this.whichTrait(trait));
    }

    @Override
    public double getData(int taxon, int trait) {
        int pheno = this.phenotypeColumn[trait][0];
        if (this.phenotypeRow[taxon][pheno] == -1) {
            return Double.NaN;
        }
        return this.phenotypes[pheno].getData(this.phenotypeRow[taxon][pheno], this.phenotypeColumn[trait][1]);
    }

    public void setData(Taxon taxon, Trait trait, double value) {
        this.setData(this.whichTaxon(taxon), this.whichTrait(trait), value);
    }

    @Override
    public void setData(int taxon, int trait, double value) {
        int pheno = this.phenotypeColumn[trait][0];
        this.phenotypes[pheno].setData(this.phenotypeRow[taxon][pheno], this.phenotypeColumn[trait][1], value);
    }

    public SimplePhenotype simpleCopy() {
        return new SimplePhenotype(this.getTaxa(), this.getTraits(), this.getData());
    }
}

