/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.taxa.IdGroupUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.trait.FilterPhenotype;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.util.TableReport;

public class MarkerPhenotype
implements TableReport {
    private GenotypeTable myAlignment;
    private Phenotype myPhenotype;

    private MarkerPhenotype(GenotypeTable alignment, Phenotype phenotype) {
        this.myAlignment = alignment;
        this.myPhenotype = phenotype;
    }

    public static MarkerPhenotype getInstance(GenotypeTable aa, Phenotype ca, boolean union) {
        TaxaList idGroup = MarkerPhenotype.getIdGroup(aa.taxa(), ca.getTaxa(), union);
        GenotypeTable align = FilterGenotypeTable.getInstance(aa, idGroup);
        FilterPhenotype phenotype = FilterPhenotype.getInstance(ca, idGroup, null);
        return new MarkerPhenotype(align, phenotype);
    }

    public static MarkerPhenotype getInstance(MarkerPhenotype aac, TaxaList group) {
        GenotypeTable aa = FilterGenotypeTable.getInstance(aac.getAlignment(), group);
        FilterPhenotype ca = FilterPhenotype.getInstance(aac.getPhenotype(), group, null);
        return new MarkerPhenotype(aa, ca);
    }

    private static TaxaList getIdGroup(TaxaList group1, TaxaList group2, boolean union) {
        if (union) {
            return IdGroupUtils.getAllIds(group1, group2);
        }
        return IdGroupUtils.getCommonIds(group1, group2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("  ");
        builder.append(this.myAlignment.numberOfTaxa());
        builder.append(" ");
        builder.append(this.myPhenotype.getNumberOfTraits());
        builder.append("Taxa/Trait\t");
        for (int j = 0; j < this.myPhenotype.getNumberOfTraits(); ++j) {
            builder.append(this.myPhenotype.getTrait(j).getName());
            builder.append("\t");
        }
        builder.append("\n");
        for (int i = 0; i < this.myAlignment.numberOfTaxa(); ++i) {
            builder.append(this.myAlignment.taxaName(i));
            builder.append("\t");
            for (int j = 0; j < this.myPhenotype.getNumberOfTraits(); ++j) {
                builder.append(this.myPhenotype.getData(i, j));
                builder.append("\t");
            }
            builder.append(this.myAlignment.genotypeAsStringRow(i));
        }
        return builder.toString();
    }

    public GenotypeTable getAlignment() {
        return this.myAlignment;
    }

    public Phenotype getPhenotype() {
        return this.myPhenotype;
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] basicLabels = new String[this.myPhenotype.getNumberOfTraits() + 2];
        basicLabels[0] = "Taxa";
        for (int c = 0; c < this.myPhenotype.getNumberOfTraits(); ++c) {
            basicLabels[c + 1] = this.myPhenotype.getTrait(c).getName();
        }
        basicLabels[this.myPhenotype.getNumberOfTraits() + 1] = "Haplotype";
        return basicLabels;
    }

    @Override
    public Object[][] getTableData() {
        return this.getTableData(0, this.getRowCount() - 1);
    }

    @Override
    public String getTableTitle() {
        return "Phenotypes and Genotypes";
    }

    @Override
    public int getColumnCount() {
        return this.myPhenotype.getNumberOfTraits() + 2;
    }

    @Override
    public int getRowCount() {
        return this.myAlignment.numberOfTaxa();
    }

    @Override
    public int getElementCount() {
        return this.getRowCount() * this.getColumnCount();
    }

    @Override
    public Object[] getRow(int row) {
        Object[] data = new String[this.myPhenotype.getNumberOfTraits() + 2];
        data[0] = this.myAlignment.taxaName(row);
        for (int c = 0; c < this.myPhenotype.getNumberOfTraits(); ++c) {
            data[c + 1] = "" + this.myPhenotype.getData(row, c);
        }
        int siteCount = Math.min(this.myAlignment.numberOfSites(), 10);
        StringBuilder builder = new StringBuilder();
        builder.append(this.myAlignment.genotypeAsStringRange(row, 0, siteCount));
        if (this.myAlignment.numberOfSites() > 10) {
            builder.append("...");
        }
        data[this.myPhenotype.getNumberOfTraits() + 1] = builder.toString();
        return data;
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        if (start < 0 || end >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("getTableData: start: " + start + "  end: " + end);
        }
        if (end < start) {
            return null;
        }
        Object[][] temp = new Object[end - start + 1][];
        for (int i = start; i <= end; ++i) {
            temp[i] = this.getRow(i);
        }
        return temp;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int haplotypeColumn = this.myPhenotype.getColumnCount();
        if (col == haplotypeColumn) {
            int siteCount = Math.min(this.myAlignment.numberOfSites(), 10);
            StringBuilder builder = new StringBuilder();
            builder.append(this.myAlignment.genotypeAsStringRange(row, 0, siteCount));
            if (this.myAlignment.numberOfSites() > 10) {
                builder.append("...");
            }
            return builder.toString();
        }
        return this.myPhenotype.getValueAt(row, col);
    }
}

