/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.Comparator;
import java.util.Map;
import net.maizegenetics.util.GeneralAnnotation;

public class AbstractAnnotation
implements GeneralAnnotation {
    public static final Object[] EMPTYOBJ = new Object[0];
    public static final String[] EMPTYSTR = new String[0];
    public static final double[] EMPTYdouble = new double[0];
    private final ImmutableMultimap<String, Object> myAnnoMap;

    public AbstractAnnotation(ImmutableMultimap<String, Object> myAnnoMap) {
        this.myAnnoMap = myAnnoMap;
    }

    @Override
    public Object[] getAnnotation(String annoName) {
        try {
            return this.myAnnoMap.get((Object)annoName).toArray();
        }
        catch (Exception e) {
            return EMPTYOBJ;
        }
    }

    @Override
    public String[] getTextAnnotation(String annoName) {
        try {
            return (String[])this.myAnnoMap.get((Object)annoName).toArray((Object[])new String[0]);
        }
        catch (Exception e) {
            return EMPTYSTR;
        }
    }

    @Override
    public double[] getQuantAnnotation(String annoName) {
        try {
            Object[] o = this.myAnnoMap.get((Object)annoName).toArray();
            if (o == null || !(o[0] instanceof Number)) {
                return EMPTYdouble;
            }
            double[] d = new double[o.length];
            int i = 0;
            for (Object o1 : o) {
                d[i++] = ((Number)o1).doubleValue();
            }
            return d;
        }
        catch (Exception e) {
            return EMPTYdouble;
        }
    }

    @Override
    public String getConsensusAnnotation(String annoName) {
        return null;
    }

    @Override
    public double getAverageAnnotation(String annoName) {
        return 0.0;
    }

    public Map.Entry[] getAllAnnotationEntries() {
        return new Map.Entry[0];
    }

    @Override
    public SetMultimap<String, String> getAnnotationAsMap() {
        ImmutableSetMultimap.Builder result = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (Map.Entry en : this.getAllAnnotationEntries()) {
            result.put(en.getKey(), (Object)en.getValue().toString());
        }
        return result.build();
    }
}

