/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DirectoryCrawler {
    private static final String DEFAULT_DIRECTORY = ".";

    private DirectoryCrawler() {
    }

    public static File[] listFiles(String pattern, File[] inputArray) {
        List<File> outputList = null;
        for (File file : inputArray) {
            outputList = DirectoryCrawler.traverse(file, pattern);
        }
        File[] outputArray = outputList.toArray(new File[outputList.size()]);
        return outputArray;
    }

    public static String[] listFileNames(String pattern, String inputFile) {
        File[] outputFiles = DirectoryCrawler.listFiles(pattern, inputFile);
        String[] outputNames = new String[outputFiles.length];
        for (int i = 0; i < outputFiles.length; ++i) {
            outputNames[i] = outputFiles[i].getAbsolutePath();
        }
        return outputNames;
    }

    public static File[] listFiles(String pattern, File inputFile) {
        return DirectoryCrawler.listFiles(pattern, new File[]{inputFile});
    }

    public static File[] listFiles(String pattern) {
        return DirectoryCrawler.listFiles(pattern, new File[]{new File(DEFAULT_DIRECTORY)});
    }

    public static File[] listFiles(String pattern, String inputFile) {
        return DirectoryCrawler.listFiles(pattern, new File[]{new File(inputFile)});
    }

    public static File[] listFiles(String pattern, String[] inputFiles) {
        File[] inputArray = new File[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            inputArray[i] = new File(inputFiles[i]);
        }
        return DirectoryCrawler.listFiles(pattern, inputArray);
    }

    private static List<File> traverse(File file, String pattern) {
        ArrayList<File> outputList = new ArrayList<File>();
        if (file.isDirectory()) {
            String[] entries = file.list();
            if (entries != null) {
                for (String entry : entries) {
                    List<File> temp = DirectoryCrawler.traverse(new File(file, entry), pattern);
                    outputList.addAll(temp);
                }
            }
        } else if (file.getName().matches(pattern)) {
            outputList.add(file);
        }
        return outputList;
    }
}

