/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class ExceptionUtils {
    public static final int DEFAULT_MAX_NUMBER_ENTRIES = 50;

    private ExceptionUtils() {
    }

    public static void logStackTrace(Exception exception, Logger logger) {
        ExceptionUtils.logStackTrace(exception, 50, logger, Level.DEBUG);
    }

    public static void logStackTrace(Exception exception, int max, Logger logger, Level priorty) {
        logger.log((Priority)priorty, (Object)ExceptionUtils.getStackTrace(exception, max));
    }

    public static String getStackTrace(Exception exception, int max) {
        StackTraceElement[] elements = exception.getStackTrace();
        int numEntries = elements.length;
        if (max >= 0 && max < numEntries) {
            numEntries = max;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numEntries; ++i) {
            buffer.append(elements[i].toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static void logExceptionCauses(Throwable exception, Logger logger, Level priorty) {
        logger.log((Priority)priorty, (Object)ExceptionUtils.getExceptionCausesWithClassNames(exception));
    }

    public static String getExceptionCauses(Throwable exception) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(exception.getMessage());
        Throwable cause = exception.getCause();
        while (cause != null) {
            Throwable temp;
            buffer.append("\n");
            buffer.append(cause.getMessage());
            cause = temp = cause.getCause();
        }
        String str = buffer.toString();
        return str;
    }

    public static String getExceptionCausesWithClassNames(Throwable exception) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(exception.toString());
        Throwable cause = exception.getCause();
        while (cause != null) {
            Throwable temp;
            buffer.append("\n");
            buffer.append(cause.toString());
            cause = temp = cause.getCause();
        }
        String str = buffer.toString();
        return str;
    }
}

