/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.text.DecimalFormat;
import java.util.Arrays;

public class Histogram {
    double[] data;
    double[] binPos;
    double[] binFreq;
    double[] binProp;
    int numDataPoints;
    int numBins = 10;
    double topDatum;
    double bottomDatum;
    double binWidth;
    double binFudgeFactor = 1.0E-4;

    public Histogram(double[][] sqrData) {
        this.numDataPoints = sqrData.length * (sqrData.length - 1) / 2;
        this.data = new double[this.numDataPoints];
        this.binFreq = new double[this.numBins];
        int c = 0;
        for (int i = 0; i < sqrData.length; ++i) {
            for (int j = 0; j < i; ++j) {
                this.data[c] = sqrData[i][j];
                ++c;
            }
        }
        this.sortData();
        this.topDatum = this.data[this.numDataPoints - 1];
        this.bottomDatum = this.data[0];
        this.findBinPositions();
        this.calculateBinFreq(this.numDataPoints);
    }

    public Histogram(double[][] sqrData, double top, double bottom, int bins) {
        this.numBins = bins;
        this.topDatum = top;
        this.bottomDatum = bottom;
        this.numDataPoints = sqrData.length * (sqrData.length - 1) / 2;
        this.data = new double[this.numDataPoints];
        this.binFreq = new double[this.numBins];
        int c = 0;
        for (int i = 0; i < sqrData.length; ++i) {
            for (int j = 0; j < i; ++j) {
                this.data[c] = sqrData[i][j];
                ++c;
            }
        }
        this.sortData();
        this.findBinPositions();
        this.calculateBinFreq(this.numDataPoints);
    }

    public void addData(double[][] sqrData) {
        int currDataPoints = sqrData.length * (sqrData.length - 1) / 2;
        this.data = new double[currDataPoints];
        int c = 0;
        for (int i = 0; i < sqrData.length; ++i) {
            for (int j = 0; j < i; ++j) {
                this.data[c] = sqrData[i][j];
                ++c;
            }
        }
        this.sortData();
        Arrays.sort(this.data);
        this.calculateBinFreq(currDataPoints);
        this.numDataPoints += currDataPoints;
    }

    private void sortData() {
    }

    private void findBinPositions() {
        this.binWidth = (this.topDatum - this.bottomDatum) / (double)this.numBins;
        this.binPos = new double[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            this.binPos[i] = this.bottomDatum + (double)(i + 1) * this.binWidth + this.binFudgeFactor;
        }
    }

    private void calculateBinFreq(int currDataPoints) {
        int currBin = 0;
        for (int i = 0; i < currDataPoints; ++i) {
            while (this.data[i] > this.binPos[currBin]) {
                ++currBin;
            }
            int n = currBin;
            this.binFreq[n] = this.binFreq[n] + 1.0;
        }
    }

    public void convertFreqToProportion() {
        this.binProp = new double[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            this.binProp[i] = this.binFreq[i] / (double)this.numDataPoints;
        }
    }

    public String writeHistogram() {
        String s = new String();
        DecimalFormat dF = new DecimalFormat("0.000");
        double currBottom = this.bottomDatum;
        for (int i = 0; i < this.numBins; ++i) {
            s = s + "Bin" + i + " [" + dF.format(currBottom) + " - " + dF.format(this.binPos[i]) + "] = " + dF.format(this.binProp[i]) + "\n";
            currBottom = this.binPos[i];
        }
        s = s + "\n";
        return s;
    }

    public double getFreqOfSampleBelowCutoff(double cutoff) {
        double cumFreq = 0.0;
        for (int i = 0; i < this.numBins; ++i) {
            if (!((cumFreq += this.binFreq[i]) > cutoff)) continue;
            return this.binPos[i];
        }
        return this.binPos[this.numBins - 1];
    }

    public String kolmogorovSmirnovTest(Histogram expectedHist, double alpha) {
        if (this.numBins != expectedHist.numBins || this.binWidth != expectedHist.binWidth || this.bottomDatum != expectedHist.bottomDatum) {
            return "These frequencies distributions were not setup in the same way and can't be compared.\n";
        }
        DecimalFormat dF = new DecimalFormat("0.0####");
        double obsF = 0.0;
        double expF = 0.0;
        double maxD = -1.0;
        double obsN = this.numDataPoints;
        double expN = expectedHist.numDataPoints;
        String s = "Kolmogorov-Smirnov Two Sample Test\n";
        for (int i = 0; i < this.numBins; ++i) {
            double d = Math.abs((obsF += this.binFreq[i]) / obsN - (expF += expectedHist.binFreq[i]) / expN);
            if (!(d > maxD)) continue;
            maxD = d;
        }
        double kAlpha = Math.sqrt(-0.5 * Math.log(alpha / 2.0));
        double dAlpha = kAlpha * Math.sqrt((obsN + expN) / (obsN * expN));
        s = s + "?=" + dF.format(alpha) + " K=" + dF.format(kAlpha) + " critical D=" + dF.format(dAlpha) + "\n";
        s = s + "Observed D=" + dF.format(maxD) + "\n";
        s = maxD > dAlpha ? s + "D is significant at the " + dF.format(alpha) + " level.\n\n" : s + "D is NOT significant at the " + dF.format(alpha) + " level.\n\n";
        return s;
    }
}

