/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.Serializable;
import java.util.Arrays;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;

public class OpenBitSet
implements BitSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5197800047652332969L;
    private long[] myBits;
    private int myNumWords;

    public OpenBitSet(long numBits) {
        this.myBits = new long[BitUtil.bits2words(numBits)];
        this.myNumWords = this.myBits.length;
    }

    public OpenBitSet() {
        this(64L);
    }

    public OpenBitSet(long[] bits, int numWords) {
        if (numWords > bits.length) {
            throw new IllegalArgumentException("OpenBitSet: init: num of words should be less than or equeal to bits length.");
        }
        this.myBits = bits;
        this.myNumWords = numWords;
    }

    public OpenBitSet(long[] bits) {
        this.myBits = bits;
        this.myNumWords = bits.length;
    }

    public OpenBitSet(BitSet cloneOBS) {
        this.myBits = (long[])cloneOBS.getBits().clone();
        this.myNumWords = cloneOBS.getNumWords();
    }

    @Override
    public long capacity() {
        return this.myBits.length << 6;
    }

    @Override
    public long size() {
        return this.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    @Override
    public long[] getBits() {
        return this.myBits;
    }

    @Override
    public long getBits(int index) {
        return this.myBits[index];
    }

    @Override
    public void setBits(long[] bits) {
        this.myBits = bits;
    }

    @Override
    public void setLong(int wordNum, long bits) {
        this.myBits[wordNum] = bits;
    }

    @Override
    public int getNumWords() {
        return this.myNumWords;
    }

    @Override
    public void setNumWords(int nWords) {
        this.myNumWords = nWords;
    }

    @Override
    public boolean get(int index) {
        int i = index >> 6;
        if (i >= this.myBits.length) {
            return false;
        }
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.myBits[i] & bitmask) != 0L;
    }

    @Override
    public boolean fastGet(int index) {
        int i = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.myBits[i] & bitmask) != 0L;
    }

    @Override
    public boolean get(long index) {
        int i = (int)(index >> 6);
        if (i >= this.myBits.length) {
            return false;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.myBits[i] & bitmask) != 0L;
    }

    @Override
    public boolean fastGet(long index) {
        int i = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.myBits[i] & bitmask) != 0L;
    }

    @Override
    public int getBit(int index) {
        int i = index >> 6;
        int bit = index & 0x3F;
        return (int)(this.myBits[i] >>> bit) & 1;
    }

    @Override
    public void set(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] | bitmask;
    }

    @Override
    public void fastSet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] | bitmask;
    }

    @Override
    public void fastSet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] | bitmask;
    }

    @Override
    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.myBits[n] = this.myBits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.myBits[n] = this.myBits[n] | startmask;
        Arrays.fill(this.myBits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.myBits[n2] = this.myBits[n2] | endmask;
    }

    protected int expandingWordNum(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.myNumWords) {
            this.ensureCapacity(index + 1L);
            this.myNumWords = wordNum + 1;
        }
        return wordNum;
    }

    @Override
    public void fastClear(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void fastClear(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.myNumWords) {
            return;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.myNumWords) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.myBits[n] = this.myBits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.myBits[n] = this.myBits[n] & startmask;
        int middle = Math.min(this.myNumWords, endWord);
        Arrays.fill(this.myBits, startWord + 1, middle, 0L);
        if (endWord < this.myNumWords) {
            int n2 = endWord;
            this.myBits[n2] = this.myBits[n2] & endmask;
        }
    }

    @Override
    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.myNumWords) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.myBits[n] = this.myBits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.myBits[n] = this.myBits[n] & startmask;
        int middle = Math.min(this.myNumWords, endWord);
        Arrays.fill(this.myBits, startWord + 1, middle, 0L);
        if (endWord < this.myNumWords) {
            int n2 = endWord;
            this.myBits[n2] = this.myBits[n2] & endmask;
        }
    }

    @Override
    public boolean getAndSet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.myBits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] | bitmask;
        return val;
    }

    @Override
    public boolean getAndSet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.myBits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] | bitmask;
        return val;
    }

    @Override
    public void fastFlip(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] ^ bitmask;
    }

    @Override
    public void fastFlip(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] ^ bitmask;
    }

    @Override
    public void flip(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] ^ bitmask;
    }

    @Override
    public boolean flipAndGet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] ^ bitmask;
        return (this.myBits[wordNum] & bitmask) != 0L;
    }

    @Override
    public boolean flipAndGet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.myBits[n] = this.myBits[n] ^ bitmask;
        return (this.myBits[wordNum] & bitmask) != 0L;
    }

    @Override
    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.myBits[n] = this.myBits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.myBits[n] = this.myBits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.myBits[i] = this.myBits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.myBits[n2] = this.myBits[n2] ^ endmask;
    }

    @Override
    public long cardinality() {
        return BitUtil.pop_array(this.myBits, 0, this.myNumWords);
    }

    @Override
    public long cardinality(int index) {
        return BitUtil.pop_array_to_index(this.myBits, index);
    }

    public static long intersectionCount(BitSet a, BitSet b) {
        return BitUtil.pop_intersect(a.getBits(), b.getBits(), 0, Math.min(a.getNumWords(), b.getNumWords()));
    }

    public static long unionCount(BitSet a, BitSet b) {
        long tot = BitUtil.pop_union(a.getBits(), b.getBits(), 0, Math.min(a.getNumWords(), b.getNumWords()));
        if (a.getNumWords() < b.getNumWords()) {
            tot += BitUtil.pop_array(b.getBits(), a.getNumWords(), b.getNumWords() - a.getNumWords());
        } else if (a.getNumWords() > b.getNumWords()) {
            tot += BitUtil.pop_array(a.getBits(), b.getNumWords(), a.getNumWords() - b.getNumWords());
        }
        return tot;
    }

    public static long andNotCount(BitSet a, BitSet b) {
        long tot = BitUtil.pop_andnot(a.getBits(), b.getBits(), 0, Math.min(a.getNumWords(), b.getNumWords()));
        if (a.getNumWords() > b.getNumWords()) {
            tot += BitUtil.pop_array(a.getBits(), b.getNumWords(), a.getNumWords() - b.getNumWords());
        }
        return tot;
    }

    public static long xorCount(BitSet a, BitSet b) {
        long tot = BitUtil.pop_xor(a.getBits(), b.getBits(), 0, Math.min(a.getNumWords(), b.getNumWords()));
        if (a.getNumWords() < b.getNumWords()) {
            tot += BitUtil.pop_array(b.getBits(), a.getNumWords(), b.getNumWords() - a.getNumWords());
        } else if (a.getNumWords() > b.getNumWords()) {
            tot += BitUtil.pop_array(a.getBits(), b.getNumWords(), a.getNumWords() - b.getNumWords());
        }
        return tot;
    }

    @Override
    public int nextSetBit(int index) {
        int i = index >> 6;
        if (i >= this.myNumWords) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = this.myBits[i] >> subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex + BitUtil.ntz(word);
        }
        while (++i < this.myNumWords) {
            word = this.myBits[i];
            if (word == 0L) continue;
            return (i << 6) + BitUtil.ntz(word);
        }
        return -1;
    }

    @Override
    public long nextSetBit(long index) {
        int i = (int)(index >>> 6);
        if (i >= this.myNumWords) {
            return -1L;
        }
        int subIndex = (int)index & 0x3F;
        long word = this.myBits[i] >>> subIndex;
        if (word != 0L) {
            return ((long)i << 6) + (long)(subIndex + BitUtil.ntz(word));
        }
        while (++i < this.myNumWords) {
            word = this.myBits[i];
            if (word == 0L) continue;
            return ((long)i << 6) + (long)BitUtil.ntz(word);
        }
        return -1L;
    }

    @Override
    public int previousSetBit(int index) {
        int i = index >> 6;
        if (i >= this.myNumWords) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = this.myBits[i] << 63 - subIndex;
        if (word != 0L) {
            int prevIndex = subIndex;
            while (word > 0L) {
                word <<= 1;
                --prevIndex;
            }
            return (i << 6) + prevIndex;
        }
        while (--i >= 0) {
            word = this.myBits[i];
            if (word == 0L) continue;
            int prevIndex = 63;
            while (word > 0L) {
                word <<= 1;
                --prevIndex;
            }
            return (i << 6) + prevIndex;
        }
        return -1;
    }

    @Override
    public long previousSetBit(long index) {
        int i = (int)(index >> 6);
        if (i >= this.myNumWords) {
            return -1L;
        }
        int subIndex = (int)(index & 0x3FL);
        long word = this.myBits[i] << 63 - subIndex;
        if (word != 0L) {
            int prevIndex = subIndex;
            while (word > 0L) {
                word <<= 1;
                --prevIndex;
            }
            return (i << 6) + prevIndex;
        }
        while (--i >= 0) {
            word = this.myBits[i];
            if (word == 0L) continue;
            int prevIndex = 63;
            while (word > 0L) {
                word <<= 1;
                --prevIndex;
            }
            return (i << 6) + prevIndex;
        }
        return -1L;
    }

    public Object clone() {
        long[] bits = (long[])this.getBits().clone();
        return new OpenBitSet(bits, this.getNumWords());
    }

    @Override
    public void intersect(BitSet other) {
        int newLen = Math.min(this.myNumWords, other.getNumWords());
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        int pos = newLen;
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.myNumWords > newLen) {
            Arrays.fill(this.myBits, newLen, this.myNumWords, 0L);
        }
        this.myNumWords = newLen;
    }

    @Override
    public void union(BitSet other) {
        int newLen = Math.max(this.myNumWords, other.getNumWords());
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        int pos = Math.min(this.myNumWords, other.getNumWords());
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
        if (this.myNumWords < newLen) {
            System.arraycopy(otherArr, this.myNumWords, thisArr, this.myNumWords, newLen - this.myNumWords);
        }
        this.myNumWords = newLen;
    }

    @Override
    public void remove(BitSet other) {
        int idx = Math.min(this.myNumWords, other.getNumWords());
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        while (--idx >= 0) {
            int n = idx;
            thisArr[n] = thisArr[n] & (otherArr[idx] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void xor(BitSet other) {
        int newLen = Math.max(this.myNumWords, other.getNumWords());
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        int pos = Math.min(this.myNumWords, other.getNumWords());
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] ^ otherArr[pos];
        }
        if (this.myNumWords < newLen) {
            System.arraycopy(otherArr, this.myNumWords, thisArr, this.myNumWords, newLen - this.myNumWords);
        }
        this.myNumWords = newLen;
    }

    public void notXor(BitSet other) {
        int newLen = Math.max(this.myNumWords, other.getNumWords());
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        int pos = Math.min(this.myNumWords, other.getNumWords());
        while (--pos >= 0) {
            thisArr[pos] = thisArr[pos] ^ otherArr[pos] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (this.myNumWords < newLen) {
            System.arraycopy(otherArr, this.myNumWords, thisArr, this.myNumWords, newLen - this.myNumWords);
        }
        this.myNumWords = newLen;
    }

    public void not() {
        long[] thisArr = this.myBits;
        int pos = this.myNumWords;
        while (--pos >= 0) {
            thisArr[pos] = thisArr[pos] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public void and(BitSet other) {
        this.intersect(other);
    }

    @Override
    public void or(BitSet other) {
        this.union(other);
    }

    @Override
    public void andNot(BitSet other) {
        this.remove(other);
    }

    @Override
    public boolean intersects(BitSet other) {
        int pos = Math.min(this.myNumWords, other.getNumWords());
        long[] thisArr = this.myBits;
        long[] otherArr = other.getBits();
        while (--pos >= 0) {
            if ((thisArr[pos] & otherArr[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public void ensureCapacityWords(int numWords) {
        if (this.myBits.length < numWords) {
            long[] newBits = new long[numWords];
            System.arraycopy(this.myBits, 0, newBits, 0, this.myNumWords);
            this.myBits = newBits;
        }
    }

    @Override
    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(BitUtil.bits2words(numBits));
    }

    @Override
    public void trimTrailingZeros() {
        int idx;
        for (idx = this.myNumWords - 1; idx >= 0 && this.myBits[idx] == 0L; --idx) {
        }
        this.myNumWords = idx + 1;
    }

    @Override
    public int indexOfNthSetBit(int n) {
        if (n < 1) {
            return -1;
        }
        int result = 0;
        int count = 0;
        for (int i = 0; i < this.myNumWords; ++i) {
            int currentCount = BitUtil.pop(this.myBits[i]);
            if (count + currentCount >= n) {
                long bitmask = 1L;
                while (true) {
                    if ((this.myBits[i] & bitmask) != 0L && ++count == n) {
                        return result;
                    }
                    bitmask <<= 1;
                    ++result;
                }
            }
            count += currentCount;
            result += 64;
        }
        return -1;
    }

    @Override
    public int[] getIndicesOfSetBits() {
        int[] result = new int[(int)this.cardinality()];
        int count = 0;
        for (int i = 0; i < this.myNumWords; ++i) {
            long bitmask = 1L;
            for (int j = 0; j < 64; ++j) {
                if ((this.myBits[i] & bitmask) != 0L) {
                    result[count++] = i * 64 + j;
                }
                bitmask <<= 1;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        int i;
        BitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitSet)) {
            return false;
        }
        BitSet b = (BitSet)o;
        if (b.getNumWords() > this.myNumWords) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        for (i = a.getNumWords() - 1; i >= b.getNumWords(); --i) {
            if (a.getBits()[i] == 0L) continue;
            return false;
        }
        for (i = b.getNumWords() - 1; i >= 0; --i) {
            if (a.getBits()[i] == b.getBits()[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 0L;
        int i = this.myBits.length;
        while (--i >= 0) {
            h ^= this.myBits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    @Override
    public long[] getBits(int startWord, int endWord) {
        int length = endWord - startWord + 1;
        long[] sL = new long[length];
        System.arraycopy(this.myBits, startWord, sL, 0, length);
        return sL;
    }
}

