/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

public class Sizeof {
    private static final Runtime s_runtime = Runtime.getRuntime();

    public static void main(String[] args) throws Exception {
        Sizeof.printMemoryUse();
    }

    public static void printMemoryUse() throws Exception {
        Sizeof.runGC();
        Sizeof.usedMemory();
        int count = 100000;
        Object[] objects = new Object[100000];
        long heap1 = 0L;
        for (int i = -1; i < 100000; ++i) {
            Object object = null;
            object = new Object();
            if (i >= 0) {
                objects[i] = object;
                continue;
            }
            object = null;
            Sizeof.runGC();
            heap1 = Sizeof.usedMemory();
        }
        Sizeof.runGC();
        long heap2 = Sizeof.usedMemory();
        int size = Math.round((float)(heap2 - heap1) / 100000.0f);
        System.out.println("'before' heap: " + heap1 + ", 'after' heap: " + heap2);
        System.out.println("heap delta: " + (heap2 - heap1) + ", {" + objects[0].getClass() + "} size = " + size + " bytes");
        for (int i = 0; i < 100000; ++i) {
            objects[i] = null;
        }
        objects = null;
    }

    public static long getMemoryUse() throws Exception {
        Sizeof.runGC();
        Sizeof.usedMemory();
        Sizeof.runGC();
        return Sizeof.usedMemory();
    }

    private static void runGC() throws Exception {
        for (int i = 0; i < 4; ++i) {
            Sizeof._runGC();
        }
    }

    private static void _runGC() throws Exception {
        long usedMem1 = Sizeof.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.currentThread();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = Sizeof.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }
}

