/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;

public final class Tassel5HDF5Constants {
    public static final String ROOT = "/";
    public static final String GENOTYPES_MODULE = "Genotypes";
    public static final String GENOTYPES_ATTRIBUTES_PATH = "Genotypes/";
    public static final String GENOTYPES_MAX_NUM_ALLELES = "maxNumAlleles";
    public static final String GENOTYPES_RETAIN_RARE_ALLELES = "retainRareAlleles";
    public static final String GENOTYPES_NUM_TAXA = "numTaxa";
    public static final String GENOTYPES_LOCKED = "locked";
    public static final String GENOTYPES_SCORE_TYPE = "scoreType";
    public static final String GENOTYPES_ALLELE_STATES = "Genotypes/AlleleStates";
    public static final String GENO_DESC = "Genotypes/_Descriptors/";
    public static final String ALLELE_CNT = "Genotypes/_Descriptors/AlleleCnt";
    public static final String MAF = "Genotypes/_Descriptors/MAF";
    public static final String SITECOV = "Genotypes/_Descriptors/SiteCoverage";
    public static final String ALLELE_FREQ_ORD = "Genotypes/_Descriptors/AlleleFreqOrder";
    public static final String TAXACOV = "Genotypes/_Descriptors/TaxaCoverage";
    public static final String TAXAHET = "Genotypes/_Descriptors/TaxaHet";
    public static final int BLOCK_SIZE = 65536;
    public static final String TAXA_MODULE = "Taxa";
    public static final String TAXA_ATTRIBUTES_PATH = "Taxa/";
    public static final String TAXA_NUM_TAXA = "numTaxa";
    public static final String TAXA_LOCKED = "locked";
    public static final String POSITION_MODULE = "Positions";
    public static final String POSITION_ATTRIBUTES_PATH = "Positions/";
    public static final String POSITION_NUM_SITES = "numSites";
    public static final String POSITION_HAS_REFEFERENCE = "hasReferenceAlleles";
    public static final String POSITION_GENOME_VERSION = "genomeVersion";
    public static final String POSITIONS = "Positions/Positions";
    public static final String CHROMOSOMES = "Positions/Chromosomes";
    public static final String CHROMOSOME_INDICES = "Positions/ChromosomeIndices";
    public static final String SNP_IDS = "Positions/SnpIds";
    public static final String REF_ALLELES = "Positions/ReferenceAlleles";
    public static final String ANC_ALLELES = "Positions/AncestralAlleles";
    public static final HDF5IntStorageFeatures intDeflation = HDF5IntStorageFeatures.createDeflation((int)2);
    public static final HDF5GenericStorageFeatures genDeflation = HDF5GenericStorageFeatures.createDeflation((int)2);
    public static final HDF5FloatStorageFeatures floatDeflation = HDF5FloatStorageFeatures.createDeflation((int)2);
    public static final String TAG_MODULE = "Tags";
    public static final String TAG_ATTRIBUTES_PATH = "Tags/";
    public static final String TAG_COUNT = "tagCount";
    public static final String TAG_LENGTH_LONG = "tagLengthLong";
    public static final String TAG_LOCKED = "locked";
    public static final String TAGS = "Tags/Tags";
    public static final String TAG_LENGTHS = "Tags/TagLength";
    public static final String TAG_DIST = "Tags/TagDist";
    public static final String TAG_DIST_CHUNK = "taxaDirection";

    public static final String getGenotypesPedigreePath(String taxon) {
        return GENOTYPES_ATTRIBUTES_PATH + taxon + "/pedigree";
    }

    public static final String getGenotypesCallsPath(String taxon) {
        return GENOTYPES_ATTRIBUTES_PATH + taxon + "/calls";
    }

    public static final String getGenotypesDepthPath(String taxon) {
        return GENOTYPES_ATTRIBUTES_PATH + taxon + "/depth";
    }

    public static final String getGenotypesScorePath(String taxon) {
        return GENOTYPES_ATTRIBUTES_PATH + taxon + "/score";
    }

    public static final String getTaxonPath(String taxon) {
        return TAXA_ATTRIBUTES_PATH + taxon;
    }

    private Tassel5HDF5Constants() {
    }
}

