/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.io.Reader;
import java.io.StringReader;
import org.apache.batik.css.AbstractCSSRule;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.DocumentHandlerAdapter;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSOMImportRule
extends AbstractCSSRule
implements CSSImportRule {
    protected CSSStyleSheet styleSheet;
    protected String href;
    protected MediaList media;
    protected DocumentHandler ruleHandler = new ImportRuleHandler();
    protected Parser parser;

    public CSSOMImportRule(CSSStyleSheet cSSStyleSheet, String string, MediaList mediaList) {
        super(cSSStyleSheet, null);
        this.href = string;
        this.media = mediaList;
        CSSOMStyleSheet cSSOMStyleSheet = (CSSOMStyleSheet)cSSStyleSheet;
        this.parser = cSSOMStyleSheet.getParser();
        try {
            Parser parser = CSSDocumentHandler.createParser();
            this.styleSheet = new CSSOMStyleSheet(null, cSSStyleSheet, string, null, mediaList, this, cSSOMStyleSheet.getValueFactoryMap(), parser);
            CSSDocumentHandler.parseStyleSheet((CSSOMStyleSheet)this.styleSheet, string);
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "syntax.error.at", new Object[]{string});
        }
    }

    public short getType() {
        return 3;
    }

    public String getCssText() {
        if (this.media == null) {
            return "@import \"" + this.href + "\";";
        }
        return "@import \"" + this.href + "\" " + this.media.getMediaText() + ";";
    }

    public void setCssText(String string) throws DOMException {
        try {
            this.parser.setDocumentHandler(this.ruleHandler);
            this.parser.parseRule(new InputSource((Reader)new StringReader(string)));
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)12, "rule.syntax.error", new Object[]{string});
        }
    }

    public String getHref() {
        return this.href;
    }

    public MediaList getMedia() {
        return this.media;
    }

    public CSSStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    protected class ImportRuleHandler
    extends DocumentHandlerAdapter {
        protected ImportRuleHandler() {
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            CSSOMImportRule.this.href = string;
            CSSOMImportRule.this.media = new DOMMediaList();
            int n = 0;
            while (n < sACMediaList.getLength()) {
                CSSOMImportRule.this.media.appendMedium(sACMediaList.item(n));
                ++n;
            }
            try {
                CSSOMStyleSheet cSSOMStyleSheet = (CSSOMStyleSheet)CSSOMImportRule.this.getParentStyleSheet();
                Parser parser = CSSDocumentHandler.createParser();
                CSSOMImportRule.this.styleSheet = new CSSOMStyleSheet(null, cSSOMStyleSheet, CSSOMImportRule.this.href, null, CSSOMImportRule.this.media, CSSOMImportRule.this, cSSOMStyleSheet.getValueFactoryMap(), parser);
                CSSDocumentHandler.parseStyleSheet((CSSOMStyleSheet)CSSOMImportRule.this.styleSheet, CSSOMImportRule.this.href);
            }
            catch (CSSException cSSException) {
                throw cSSException;
            }
            catch (Exception exception) {
                throw new CSSException(exception);
            }
        }
    }
}

