/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractIdentifierFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ImmutableValueList;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class FontFamilyFactory
extends AbstractValueFactory
implements ValueFactory {
    protected static final PropertyMap values = new PropertyMap();
    protected IdentFactory identFactory = new IdentFactory(this.getParser());
    protected ValueFactory stringFactory = new AbstractValueFactory.StringFactory(this.getParser());

    public FontFamilyFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "font-family";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: 
            case 36: {
                ImmutableValueList immutableValueList = new ImmutableValueList();
                do {
                    if (lexicalUnit.getLexicalUnitType() == 36) {
                        immutableValueList.append(new CSSOMValue(this.stringFactory, this.stringFactory.createValue(lexicalUnit)));
                        if (lexicalUnit != null) {
                            lexicalUnit = lexicalUnit.getNextLexicalUnit();
                        }
                    } else {
                        LexicalUnit lexicalUnit2 = lexicalUnit;
                        String string = lexicalUnit2.getStringValue();
                        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && lexicalUnit.getLexicalUnitType() == 35) {
                            do {
                                string = string + " " + lexicalUnit.getStringValue();
                            } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && lexicalUnit.getLexicalUnitType() == 35);
                            ImmutableString immutableString = new ImmutableString(19, string);
                            immutableValueList.append(new CSSOMValue(this.stringFactory, immutableString));
                        } else if (values.get(string.toLowerCase().intern()) != null) {
                            immutableValueList.append(new CSSOMValue(this.identFactory, this.identFactory.createValue(lexicalUnit2)));
                        } else {
                            string = "\"" + string + "\"";
                            immutableValueList.append(new CSSOMValue(this.stringFactory, this.stringFactory.createValue(string)));
                        }
                    }
                    if (lexicalUnit == null) continue;
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                } while (lexicalUnit != null);
                return immutableValueList;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    static {
        values.put("cursive", ValueConstants.CURSIVE_VALUE);
        values.put("fantasy", ValueConstants.FANTASY_VALUE);
        values.put("monospaced", ValueConstants.MONOSPACED_VALUE);
        values.put("serif", ValueConstants.SERIF_VALUE);
        values.put("sans-serif", ValueConstants.SANS_SERIF_VALUE);
    }

    protected class IdentFactory
    extends AbstractIdentifierFactory {
        public IdentFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        protected PropertyMap getIdentifiers() {
            return values;
        }
    }
}

