/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractIdentifierFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class FontWeightFactory
extends AbstractIdentifierFactory
implements ValueConstants {
    protected static final PropertyMap values = new PropertyMap();

    public FontWeightFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "font-weight";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 13) {
            int n = lexicalUnit.getIntegerValue();
            switch (n) {
                case 100: {
                    return ValueConstants.NUMBER_100;
                }
                case 200: {
                    return ValueConstants.NUMBER_200;
                }
                case 300: {
                    return ValueConstants.NUMBER_300;
                }
                case 400: {
                    return ValueConstants.NUMBER_400;
                }
                case 500: {
                    return ValueConstants.NUMBER_500;
                }
                case 600: {
                    return ValueConstants.NUMBER_600;
                }
                case 700: {
                    return ValueConstants.NUMBER_700;
                }
                case 800: {
                    return ValueConstants.NUMBER_800;
                }
                case 900: {
                    return ValueConstants.NUMBER_900;
                }
            }
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.number", new Object[]{new Integer(n), this.getPropertyName()});
        }
        return super.createValue(lexicalUnit);
    }

    public ImmutableValue createFloatValue(short s, float f) throws DOMException {
        int n;
        if (s == 1 && f == (float)(n = (int)f)) {
            switch (n) {
                case 100: 
                case 200: 
                case 300: 
                case 400: 
                case 500: 
                case 600: 
                case 700: 
                case 800: 
                case 900: {
                    return new ImmutableFloat(s, f);
                }
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.number", new Object[]{new Integer((int)f), this.getPropertyName()});
    }

    protected PropertyMap getIdentifiers() {
        return values;
    }

    static {
        values.put("bold", ValueConstants.BOLD_VALUE);
        values.put("bolder", ValueConstants.BOLDER_VALUE);
        values.put("lighter", ValueConstants.LIGHTER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
    }
}

