/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.value.AbstractImmutablePrimitiveValue;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.dom.DOMException;

public class ImmutableString
extends AbstractImmutablePrimitiveValue {
    protected String value;
    protected short unitType;

    public ImmutableString(short s, String string) {
        this.unitType = s;
        this.value = s == 21 ? string.toLowerCase().intern() : string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImmutableString)) {
            return false;
        }
        ImmutableString immutableString = (ImmutableString)object;
        if (this.unitType != immutableString.unitType) {
            return false;
        }
        if (this.unitType == 21) {
            return this.value == immutableString.value;
        }
        return this.value.equals(immutableString.value);
    }

    public ImmutableValue createReadOnlyCopy() {
        return this;
    }

    public String getCssText() {
        switch (this.unitType) {
            case 20: {
                return "url(" + this.value + ")";
            }
            case 19: {
                char c = this.value.indexOf(34) != -1 ? (char)'\'' : '\"';
                return c + this.value + c;
            }
        }
        return this.value;
    }

    public short getPrimitiveType() {
        return this.unitType;
    }

    public String getStringValue() throws DOMException {
        return this.value;
    }
}

