/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.phylo;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.biojava3.core.sequence.MultipleSequenceAlignment;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.FastaReader;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.template.FastaHeaderParserInterface;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.phylo.CheckTreeAccuracy;
import org.biojava3.phylo.Comparison;
import org.biojava3.phylo.NJTreeProgressListener;
import org.biojava3.phylo.ProgessListenerStub;
import org.biojava3.phylo.ResidueProperties;
import org.biojava3.phylo.ScoreMatrix;
import org.biojava3.phylo.TreeConstructionAlgorithm;
import org.biojava3.phylo.TreeType;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogenyinference.BasicSymmetricalDistanceMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.NeighborJoining;

public class TreeConstructor<C extends AbstractSequence<D>, D extends Compound>
extends Thread {
    TreeType treeType;
    TreeConstructionAlgorithm treeConstructionAlgorithm;
    NJTreeProgressListener treeProgessListener;
    MultipleSequenceAlignment<C, D> multipleSequenceAlignment = new MultipleSequenceAlignment();
    boolean verbose = false;
    Phylogeny p = null;
    DistanceMatrix matrix = null;
    DistanceMatrix copyDistanceMatrix = null;
    Vector<NJTreeProgressListener> progessListenerVector = new Vector();

    public TreeConstructor(MultipleSequenceAlignment<C, D> multipleSequenceAlignment, TreeType _treeType, TreeConstructionAlgorithm _treeConstructionAlgorithm, NJTreeProgressListener _treeProgessListener) {
        this.treeType = _treeType;
        this.treeConstructionAlgorithm = _treeConstructionAlgorithm;
        this.treeProgessListener = _treeProgessListener;
        this.multipleSequenceAlignment = multipleSequenceAlignment;
    }

    public TreeConstructor(DistanceMatrix _matrix, TreeType _treeType, TreeConstructionAlgorithm _treeConstructionAlgorithm, NJTreeProgressListener _treeProgessListener) {
        this.matrix = _matrix;
        this.copyDistanceMatrix = CheckTreeAccuracy.copyMatrix(this.matrix);
        this.treeType = _treeType;
        this.treeConstructionAlgorithm = _treeConstructionAlgorithm;
        this.treeProgessListener = _treeProgessListener;
    }

    public void outputPhylipDistances(String fileName) throws Exception {
        DistanceMatrix distances = this.getDistanceMatrix();
        if (distances == null) {
            throw new Exception("distance matrix has not been calculated. Requires process() method to be called first");
        }
        FileOutputStream fo = new FileOutputStream(fileName);
        PrintStream dos = new PrintStream(fo);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setMinimumFractionDigits(5);
        for (int row = 0; row < distances.getSize(); ++row) {
            dos.print(distances.getIdentifier(row));
            for (int col = 0; col < distances.getSize(); ++col) {
                dos.print(" " + df.format(distances.getValue(col, row)));
            }
            dos.println();
        }
        dos.close();
        fo.close();
    }

    private double[][] calculateDistanceMatrix(MultipleSequenceAlignment<C, D> multipleSequenceAlignment, TreeConstructionAlgorithm tca) {
        this.updateProgress("Determing Distances", 0);
        int numberOfSequences = multipleSequenceAlignment.getSize();
        String[] sequenceString = new String[numberOfSequences];
        for (int i = 0; i < multipleSequenceAlignment.getSize(); ++i) {
            sequenceString[i] = ((AbstractSequence)multipleSequenceAlignment.getAlignedSequence(i)).getSequenceAsString();
        }
        double[][] distance = new double[numberOfSequences][numberOfSequences];
        int totalloopcount = numberOfSequences / 2 * (numberOfSequences + 1);
        if (tca == TreeConstructionAlgorithm.PID) {
            int loopcount = 0;
            for (int i = 0; i < numberOfSequences - 1; ++i) {
                this.updateProgress("Determining Distances", loopcount * 100 / totalloopcount);
                for (int j = i; j < numberOfSequences; ++j) {
                    ++loopcount;
                    if (j == i) {
                        distance[i][i] = 0.0;
                        continue;
                    }
                    distance[i][j] = 100.0f - Comparison.PID(sequenceString[i], sequenceString[j]);
                    distance[j][i] = distance[i][j];
                }
            }
        } else {
            int j;
            int i;
            ScoreMatrix pwmatrix = ResidueProperties.getScoreMatrix(this.treeConstructionAlgorithm.name());
            if (pwmatrix == null) {
                pwmatrix = ResidueProperties.getScoreMatrix(TreeConstructionAlgorithm.BLOSUM62.name());
            }
            int maxscore = 0;
            int end = sequenceString[0].length();
            int loopcount = 0;
            for (i = 0; i < numberOfSequences - 1; ++i) {
                this.updateProgress("Determining Distances", loopcount * 100 / totalloopcount);
                for (j = i; j < numberOfSequences; ++j) {
                    int score = 0;
                    ++loopcount;
                    for (int k = 0; k < end; ++k) {
                        try {
                            score += pwmatrix.getPairwiseScore(sequenceString[i].charAt(k), sequenceString[j].charAt(k));
                            continue;
                        }
                        catch (Exception ex) {
                            System.err.println("err creating BLOSUM62 tree");
                            ex.printStackTrace();
                        }
                    }
                    distance[i][j] = score;
                    if (score <= maxscore) continue;
                    maxscore = score;
                }
            }
            for (i = 0; i < numberOfSequences - 1; ++i) {
                for (j = i; j < numberOfSequences; ++j) {
                    distance[i][j] = (double)maxscore - distance[i][j];
                    distance[j][i] = distance[i][j];
                }
            }
        }
        this.updateProgress("Determining Distances", 100);
        return distance;
    }

    public DistanceMatrix getDistanceMatrix() {
        return this.copyDistanceMatrix;
    }

    public void cancel() {
    }

    public void process() throws Exception {
        if (this.matrix == null) {
            double[][] distances = this.calculateDistanceMatrix(this.multipleSequenceAlignment, this.treeConstructionAlgorithm);
            this.matrix = new BasicSymmetricalDistanceMatrix(this.multipleSequenceAlignment.getSize());
            for (int i = 0; i < this.matrix.getSize(); ++i) {
                this.matrix.setIdentifier(i, ((AbstractSequence)this.multipleSequenceAlignment.getAlignedSequence(i)).getAccession().getID());
            }
            for (int col = 0; col < this.matrix.getSize(); ++col) {
                for (int row = 0; row < this.matrix.getSize(); ++row) {
                    this.matrix.setValue(col, row, distances[col][row]);
                }
            }
            this.copyDistanceMatrix = CheckTreeAccuracy.copyMatrix(this.matrix);
        }
        ArrayList<Phylogeny> ps = new ArrayList<Phylogeny>();
        NeighborJoining nj = NeighborJoining.createInstance();
        nj.setVerbose(this.verbose);
        ps.add(nj.execute(this.matrix));
        this.p = (Phylogeny)ps.get(0);
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNewickString(boolean simpleNewick, boolean writeDistanceToParent) throws Exception {
        PhylogenyWriter w = new PhylogenyWriter();
        StringBuffer newickString = w.toNewHampshire(this.p, simpleNewick, writeDistanceToParent);
        return newickString.toString();
    }

    public void addProgessListener(NJTreeProgressListener treeProgessListener) {
        if (treeProgessListener != null) {
            this.progessListenerVector.add(treeProgessListener);
        }
    }

    public void removeProgessListener(NJTreeProgressListener treeProgessListener) {
        if (treeProgessListener != null) {
            this.progessListenerVector.remove(treeProgessListener);
        }
    }

    public void broadcastComplete() {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.complete(this);
        }
    }

    public void updateProgress(String state, int percentage) {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.progress(this, state, percentage);
        }
    }

    public void updateProgress(String state, int currentCount, int totalCount) {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.progress(this, state, currentCount, totalCount);
        }
    }

    public static void main(String[] args) {
        try {
            InputStream inStream = TreeConstructor.class.getResourceAsStream("/PF00104_small.fasta");
            FastaReader fastaReader = new FastaReader(inStream, (FastaHeaderParserInterface)new GenericFastaHeaderParser(), (SequenceCreatorInterface)new ProteinSequenceCreator((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            inStream.close();
            MultipleSequenceAlignment multipleSequenceAlignment = new MultipleSequenceAlignment();
            for (ProteinSequence proteinSequence : proteinSequences.values()) {
                multipleSequenceAlignment.addAlignedSequence((Sequence)proteinSequence);
            }
            long readTime = System.currentTimeMillis();
            TreeConstructor treeConstructor = new TreeConstructor(multipleSequenceAlignment, TreeType.NJ, TreeConstructionAlgorithm.PID, (NJTreeProgressListener)new ProgessListenerStub());
            treeConstructor.process();
            long treeTime = System.currentTimeMillis();
            String newick = treeConstructor.getNewickString(true, true);
            System.out.println("Tree time " + (treeTime - readTime));
            System.out.println(newick);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

