/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AdapterInputStreamToIInputStream
implements IInputStream {
    private final InputStream delegate;

    public AdapterInputStreamToIInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public int available() throws IOExceptionUnchecked {
        try {
            return this.delegate.available();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void close() throws IOExceptionUnchecked {
        try {
            this.delegate.close();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public int read() throws IOExceptionUnchecked {
        try {
            return this.delegate.read();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b, int off, int len) throws IOExceptionUnchecked {
        try {
            return this.delegate.read(b, off, len);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b) throws IOExceptionUnchecked {
        try {
            return this.delegate.read(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void reset() throws IOExceptionUnchecked {
        try {
            this.delegate.reset();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public long skip(long n) throws IOExceptionUnchecked {
        try {
            return this.delegate.skip(n);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

