/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.namedthread;

import ch.systemsx.cisd.base.namedthread.ICallableNameProvider;
import ch.systemsx.cisd.base.namedthread.IRunnableNameProvider;
import ch.systemsx.cisd.base.namedthread.NamedRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedFutureTask<V>
extends FutureTask<V>
implements NamedRunnable {
    private final String name;
    private Thread thread;
    private String oldThreadName;

    NamedFutureTask(Callable<V> callable) {
        super(callable);
        this.name = callable instanceof ICallableNameProvider ? ((ICallableNameProvider)((Object)callable)).getCallableName() : null;
    }

    NamedFutureTask(Runnable runnable, V result) {
        super(runnable, result);
        this.name = runnable instanceof IRunnableNameProvider ? ((IRunnableNameProvider)((Object)runnable)).getRunnableName() : null;
    }

    void restoreThreadName() {
        if (this.thread != null) {
            this.thread.setName(this.oldThreadName);
            this.thread = null;
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
        this.oldThreadName = thread.getName();
    }

    @Override
    public String getRunnableName() {
        return this.name;
    }
}

