/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.rinn.restrictions.Private;
import java.lang.reflect.Field;
import java.util.BitSet;
import org.apache.commons.lang.SystemUtils;

public final class BitSetConversionUtils {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final Field BIT_SET_WORDS = BitSetConversionUtils.getBitSetWords();
    private static final Field BIT_SET_WORDS_IN_USE = BitSetConversionUtils.getBitSetWordsInUse();

    private static Field getBitSetWords() {
        try {
            Field bitsField = BitSet.class.getDeclaredField(SystemUtils.IS_JAVA_1_5 ? "bits" : "words");
            bitsField.setAccessible(true);
            return bitsField;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Field getBitSetWordsInUse() {
        try {
            Field unitsInUseField = BitSet.class.getDeclaredField(SystemUtils.IS_JAVA_1_5 ? "unitsInUse" : "wordsInUse");
            unitsInUseField.setAccessible(true);
            return unitsInUseField;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static BitSet fromStorageForm(long[] serializedWordArray) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.fromStorageFormFast(serializedWordArray);
        }
        return BitSetConversionUtils.fromStorageFormGeneric(serializedWordArray);
    }

    private static BitSet fromStorageFormFast(long[] serializedWordArray) {
        try {
            BitSet result = new BitSet();
            int inUse = BitSetConversionUtils.calcInUse(serializedWordArray, serializedWordArray.length);
            BIT_SET_WORDS_IN_USE.set(result, inUse);
            BIT_SET_WORDS.set(result, BitSetConversionUtils.trim(serializedWordArray, inUse));
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    @Private
    static BitSet fromStorageFormGeneric(long[] serializedWordArray) {
        BitSet result = new BitSet();
        int wordIndex = 0;
        while (wordIndex < serializedWordArray.length) {
            long word = serializedWordArray[wordIndex];
            int bitInWord = 0;
            while (bitInWord < 64) {
                if ((word & 1L << bitInWord) != 0L) {
                    result.set(wordIndex << 6 | bitInWord);
                }
                ++bitInWord;
            }
            ++wordIndex;
        }
        return result;
    }

    public static long[] toStorageForm(BitSet data) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.toStorageFormFast(data);
        }
        return BitSetConversionUtils.toStorageFormGeneric(data);
    }

    public static long[] toStorageForm(BitSet data, int numberOfWords) {
        if (BIT_SET_WORDS != null) {
            return BitSetConversionUtils.toStorageFormFast(data, numberOfWords);
        }
        return BitSetConversionUtils.toStorageFormGeneric(data, numberOfWords);
    }

    private static long[] toStorageFormFast(BitSet data) {
        try {
            long[] storageForm = (long[])BIT_SET_WORDS.get(data);
            int inUse = BIT_SET_WORDS_IN_USE.getInt(data);
            return BitSetConversionUtils.trim(storageForm, inUse);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    private static long[] toStorageFormFast(BitSet data, int numberOfWords) {
        try {
            long[] storageForm = (long[])BIT_SET_WORDS.get(data);
            return BitSetConversionUtils.trimEnforceLen(storageForm, numberOfWords);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    private static long[] trim(long[] array, int len) {
        int inUse = BitSetConversionUtils.calcInUse(array, len);
        if (inUse < array.length) {
            long[] trimmedArray = new long[inUse];
            System.arraycopy(array, 0, trimmedArray, 0, inUse);
            return trimmedArray;
        }
        return array;
    }

    private static long[] trimEnforceLen(long[] array, int len) {
        if (len != array.length) {
            long[] trimmedArray = new long[len];
            int inUse = BitSetConversionUtils.calcInUse(array, len);
            System.arraycopy(array, 0, trimmedArray, 0, inUse);
            return trimmedArray;
        }
        return array;
    }

    private static int calcInUse(long[] array, int len) {
        int result = Math.min(len, array.length);
        while (result > 0 && array[result - 1] == 0L) {
            --result;
        }
        return result;
    }

    public static int getWordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public static long getBitMaskInWord(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    static long[] toStorageFormGeneric(BitSet data) {
        long[] words = new long[data.size() >> 6];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex;
            int n = wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }

    static long[] toStorageFormGeneric(BitSet data, int numberOfWords) {
        long[] words = new long[numberOfWords];
        int bitIndex = data.nextSetBit(0);
        while (bitIndex >= 0) {
            int wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
            if (wordIndex >= words.length) break;
            int n = wordIndex;
            words[n] = words[n] | BitSetConversionUtils.getBitMaskInWord(bitIndex);
            bitIndex = data.nextSetBit(bitIndex + 1);
        }
        return words;
    }
}

