/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CharacterEncoding {
    ASCII("ASCII", HDF5Constants.H5T_CSET_ASCII),
    UTF8("UTF8", HDF5Constants.H5T_CSET_UTF8);

    private String charSetName;
    private int cValue;

    private CharacterEncoding(String charSetName, int cValue) {
        this.charSetName = charSetName;
        this.cValue = cValue;
    }

    int getCValue() {
        return this.cValue;
    }

    String getCharSetName() {
        return this.charSetName;
    }

    static CharacterEncoding fromCValue(int cValue) throws IllegalArgumentException {
        if (cValue == HDF5Constants.H5T_CSET_ASCII) {
            return ASCII;
        }
        if (cValue == HDF5Constants.H5T_CSET_UTF8) {
            return UTF8;
        }
        throw new IllegalArgumentException("Illegal character encoding id " + cValue);
    }
}

