/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ByteWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5ByteWriter
implements IHDF5ByteWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5ByteWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setByteAttribute(String objectPath, String name, byte value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_I8LE, HDF5Constants.H5T_NATIVE_INT8, new byte[]{value});
    }

    public void setByteArrayAttribute(final String objectPath, final String name, final byte[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, value.length, registry);
                int storageTypeId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I8LE, value.length, registry);
                HDF5ByteWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setByteMDArrayAttribute(final String objectPath, final String name, final MDByteArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT8, value.dimensions(), registry);
                int storageTypeId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I8LE, value.dimensions(), registry);
                HDF5ByteWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setByteMatrixAttribute(String objectPath, String name, byte[][] value) {
        this.setByteMDArrayAttribute(objectPath, name, new MDByteArray(value));
    }

    public void writeByte(String objectPath, byte value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I8LE, HDF5Constants.H5T_NATIVE_INT8, value);
    }

    public void writeByteArray(String objectPath, byte[] data) {
        this.writeByteArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeByteArray(final String objectPath, final byte[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5ByteWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, new long[]{data.length}, 1, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT8, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createByteArray(String objectPath, int size) {
        this.createByteArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteArray(String objectPath, long size, int blockSize) {
        this.createByteArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, new long[1], new long[]{size}, 1, registry);
                } else {
                    HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, new long[]{size}, null, 1, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createByteArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, new long[]{size}, new long[]{blockSize}, 1, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeByteArrayBlock(String objectPath, byte[] data, long blockNumber) {
        this.writeByteArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeByteArrayBlockWithOffset(final String objectPath, final byte[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileId, objectPath, ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT8, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeByteMatrix(String objectPath, byte[][] data) {
        this.writeByteMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeByteMatrix(String objectPath, byte[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeByteMDArray(objectPath, new MDByteArray(data), features);
    }

    public void createByteMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createByteMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createByteMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, dimensions, blockDimensions, 1, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeByteMatrixBlock(String objectPath, byte[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeByteMDArrayBlock(objectPath, new MDByteArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeByteMatrixBlockWithOffset(String objectPath, byte[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeByteMDArrayBlockWithOffset(objectPath, new MDByteArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeByteMatrixBlockWithOffset(String objectPath, byte[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeByteMDArrayBlockWithOffset(objectPath, new MDByteArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeByteMDArray(String objectPath, MDByteArray data) {
        this.writeByteMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeByteMDArray(final String objectPath, final MDByteArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5ByteWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, data.longDimensions(), 1, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT8, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createByteMDArray(String objectPath, int[] dimensions) {
        this.createByteMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createByteMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createByteMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, nullDimensions, MDArray.toLong(dimensions), 1, registry);
                } else {
                    HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, MDArray.toLong(dimensions), null, 1, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createByteMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ByteWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I8LE : HDF5Constants.H5T_STD_U8LE, features, dimensions, MDArray.toLong(blockDimensions), 1, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeByteMDArrayBlock(String objectPath, MDByteArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeByteMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeByteMDArrayBlockWithOffset(final String objectPath, final MDByteArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileId, objectPath, ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT8, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeByteMDArrayBlockWithOffset(final String objectPath, final MDByteArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileId, objectPath, ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5ByteWriter)HDF5ByteWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT8, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

