/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CompoundElement;
import ch.systemsx.cisd.hdf5.CompoundType;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5CompoundType<T>
extends HDF5DataType {
    private final String nameOrNull;
    private final Class<T> compoundType;
    private final HDF5ValueObjectByteifyer<T> objectByteifyer;
    private final IHDF5InternalCompoundMemberInformationRetriever informationRetriever;

    HDF5CompoundType(int fileId, int storageTypeId, int nativeTypeId, String nameOrNull, Class<T> compoundType, HDF5ValueObjectByteifyer<T> objectByteifer, IHDF5InternalCompoundMemberInformationRetriever informationRetriever, HDF5BaseReader baseReader) {
        super(fileId, storageTypeId, nativeTypeId, baseReader);
        assert (compoundType != null);
        assert (objectByteifer != null);
        assert (informationRetriever != null);
        this.nameOrNull = nameOrNull;
        this.compoundType = compoundType;
        this.objectByteifyer = objectByteifer;
        this.informationRetriever = informationRetriever;
    }

    public Class<T> getCompoundType() {
        return this.compoundType;
    }

    public int getRecordSize() {
        return this.objectByteifyer.getRecordSize();
    }

    public HDF5CompoundMemberInformation[] getCompoundMemberInformation() {
        return this.getCompoundMemberInformation(HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    public HDF5CompoundMemberInformation[] getCompoundMemberInformation(HDF5DataTypeInformation.DataTypeInfoOptions options) {
        return this.informationRetriever.getCompoundMemberInformation(options);
    }

    public boolean isMappingIncomplete() {
        return this.isMemoryRepresentationIncomplete() || this.isDiskRepresentationIncomplete();
    }

    public boolean isMemoryRepresentationIncomplete() {
        return this.objectByteifyer.hasUnmappedMembers();
    }

    public String[] getUnmappedCompoundMemberNames() {
        return this.objectByteifyer.getUnmappedMembers();
    }

    private Map<String, HDF5CompoundMemberInformation> getCompoundMemberInformationMap() {
        HashMap<String, HDF5CompoundMemberInformation> result = new HashMap<String, HDF5CompoundMemberInformation>();
        HDF5CompoundMemberInformation[] hDF5CompoundMemberInformationArray = this.getCompoundMemberInformation();
        int n = hDF5CompoundMemberInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5CompoundMemberInformation info = hDF5CompoundMemberInformationArray[n2];
            result.put(info.getName(), info);
            ++n2;
        }
        return result;
    }

    public HDF5CompoundMemberInformation[] getUnmappedCompoundMemberInformation() {
        String[] unmappedCompoundMemberNames = this.getUnmappedCompoundMemberNames();
        if (unmappedCompoundMemberNames.length > 0) {
            Map<String, HDF5CompoundMemberInformation> compoundMemberInfoMap = this.getCompoundMemberInformationMap();
            HDF5CompoundMemberInformation[] result = new HDF5CompoundMemberInformation[unmappedCompoundMemberNames.length];
            int idx = 0;
            String[] stringArray = unmappedCompoundMemberNames;
            int n = unmappedCompoundMemberNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                result[idx++] = compoundMemberInfoMap.get(name);
                ++n2;
            }
            return result;
        }
        return new HDF5CompoundMemberInformation[0];
    }

    public boolean isDiskRepresentationIncomplete() {
        return !this.getUnmappedFields().isEmpty();
    }

    public void checkMappingComplete() throws HDF5JavaException {
        String[] unmappedMembers = this.getUnmappedCompoundMemberNames();
        String[] unmappedFields = this.getUnmappedFieldNames();
        if (unmappedMembers.length > 0 || unmappedFields.length > 0) {
            StringBuilder b = new StringBuilder();
            b.append("Incomplete mapping for compound type '");
            b.append(this.getName());
            b.append("': ");
            if (unmappedMembers.length > 0) {
                b.append("unmapped members: ");
                b.append(ArrayUtils.toString(unmappedMembers));
            }
            if (unmappedMembers.length > 0 && unmappedFields.length > 0) {
                b.append(", ");
            }
            if (unmappedFields.length > 0) {
                b.append("unmapped fields: ");
                b.append(ArrayUtils.toString(unmappedFields));
            }
            throw new HDF5JavaException(b.toString());
        }
    }

    public String[] getUnmappedFieldNames() {
        Set<Field> unmappedFields = this.getUnmappedFields();
        String[] result = new String[unmappedFields.size()];
        int idx = 0;
        for (Field field : unmappedFields) {
            result[idx++] = field.getName();
        }
        return result;
    }

    private Set<Field> getUnmappedFields() {
        if (Map.class.isAssignableFrom(this.compoundType) || List.class.isAssignableFrom(this.compoundType) || this.compoundType == Object[].class) {
            return Collections.emptySet();
        }
        HashSet<Field> fieldSet = new HashSet<Field>(ReflectionUtils.getFieldMap(this.compoundType).values());
        CompoundType ct = this.compoundType.getAnnotation(CompoundType.class);
        if (ct != null && !ct.mapAllFields()) {
            Iterator it = fieldSet.iterator();
            while (it.hasNext()) {
                Field f = (Field)it.next();
                CompoundElement ce = f.getAnnotation(CompoundElement.class);
                if (ce != null) continue;
                it.remove();
            }
        }
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.objectByteifyer.getByteifyers();
        int n = hDF5MemberByteifyerArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteiyfer = hDF5MemberByteifyerArray[n2];
            fieldSet.remove(byteiyfer.tryGetField());
            ++n2;
        }
        return fieldSet;
    }

    HDF5ValueObjectByteifyer<T> getObjectByteifyer() {
        return this.objectByteifyer;
    }

    @Override
    public String tryGetName() {
        return this.nameOrNull;
    }

    public String toString() {
        if (this.nameOrNull != null) {
            return "HDF5CompoundType [nameOrNull=" + this.nameOrNull + ", compoundType=" + this.compoundType.getSimpleName() + ", objectByteifyer=" + this.objectByteifyer + "]";
        }
        return "HDF5CompoundType [compoundType=" + this.compoundType.getSimpleName() + ", objectByteifyer=" + this.objectByteifyer + "]";
    }

    static interface IHDF5InternalCompoundMemberInformationRetriever {
        public HDF5CompoundMemberInformation[] getCompoundMemberInformation(HDF5DataTypeInformation.DataTypeInfoOptions var1);
    }
}

