/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public abstract class HDF5DataType {
    private int fileId;
    private int storageTypeId;
    private int nativeTypeId;
    private final HDF5BaseReader baseReader;

    HDF5DataType(int fileId, int storageTypeId, int nativeTypeId, HDF5BaseReader baseReader) {
        assert (fileId >= 0);
        this.fileId = fileId;
        this.storageTypeId = storageTypeId;
        this.nativeTypeId = nativeTypeId;
        this.baseReader = baseReader;
        baseReader.fileRegistry.registerCleanUp(new Runnable(){

            public void run() {
                HDF5DataType.this.fileId = -1;
                HDF5DataType.this.storageTypeId = -1;
                HDF5DataType.this.nativeTypeId = -1;
            }
        });
    }

    int getStorageTypeId() {
        return this.storageTypeId;
    }

    int getNativeTypeId() {
        return this.nativeTypeId;
    }

    void check(int expectedFileId) throws HDF5JavaException {
        if (this.fileId < 0) {
            throw new HDF5JavaException("Type " + this.getName() + " is closed.");
        }
        if (this.fileId != expectedFileId) {
            throw new HDF5JavaException("Type " + this.getName() + " is not from this file.");
        }
    }

    void checkOpen() throws HDF5JavaException {
        if (this.fileId < 0) {
            throw new HDF5JavaException("Type " + this.getName() + " is closed.");
        }
    }

    public abstract String tryGetName();

    public String getName() {
        String nameOrNull = this.tryGetName();
        return nameOrNull == null ? "UNKNOWN" : nameOrNull;
    }

    public String tryGetDataTypePath() {
        return this.getDataTypeInformation(HDF5DataTypeInformation.DataTypeInfoOptions.PATH).tryGetDataTypePath();
    }

    public HDF5DataTypeInformation getDataTypeInformation(HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.baseReader.getDataTypeInformation(this.storageTypeId, dataTypeInfoOptions);
    }

    public HDF5DataTypeInformation getDataTypeInformation() {
        return this.baseReader.getDataTypeInformation(this.storageTypeId, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fileId;
        result = 31 * result + this.storageTypeId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5DataType other = (HDF5DataType)obj;
        if (this.fileId != other.fileId) {
            return false;
        }
        return this.storageTypeId == other.storageTypeId;
    }
}

