/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5DoubleReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5DoubleReader
implements IHDF5DoubleReader {
    private final HDF5BaseReader baseReader;

    HDF5DoubleReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public double getDoubleAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Double> getAttributeRunnable = new ICallableWithCleanUp<Double>(){

            @Override
            public Double call(ICleanUpRegistry registry) {
                int objectId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openObject(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                double[] data = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readAttributeAsDoubleArray(attributeId, HDF5Constants.H5T_NATIVE_DOUBLE, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public double[] getDoubleArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<double[]> getAttributeRunnable = new ICallableWithCleanUp<double[]>(){

            @Override
            public double[] call(ICleanUpRegistry registry) {
                int memoryTypeId;
                int len;
                Object[] arrayDimensions;
                int objectId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openObject(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int attributeTypeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                if (((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                    if (arrayDimensions.length != 1) {
                        throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
                    }
                    len = arrayDimensions[0];
                    memoryTypeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, len, registry);
                } else {
                    arrayDimensions = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    memoryTypeId = HDF5Constants.H5T_NATIVE_DOUBLE;
                    len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
                }
                double[] data = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readAttributeAsDoubleArray(attributeId, memoryTypeId, len);
                return data;
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDDoubleArray getDoubleMDArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDDoubleArray> getAttributeRunnable = new ICallableWithCleanUp<MDDoubleArray>(){

            @Override
            public MDDoubleArray call(ICleanUpRegistry registry) {
                try {
                    int memoryTypeId;
                    int[] arrayDimensions;
                    int objectId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openObject(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                    int attributeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                    int attributeTypeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                    if (((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                        arrayDimensions = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                        memoryTypeId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, arrayDimensions, registry);
                    } else {
                        arrayDimensions = MDArray.toInt(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                        memoryTypeId = HDF5Constants.H5T_NATIVE_DOUBLE;
                    }
                    int len = MDArray.getLength(arrayDimensions);
                    double[] data = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readAttributeAsDoubleArray(attributeId, memoryTypeId, len);
                    return new MDDoubleArray(data, arrayDimensions);
                }
                catch (IllegalArgumentException ex) {
                    throw new HDF5JavaException(ex.getMessage());
                }
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public double[][] getDoubleMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        MDDoubleArray array = this.getDoubleMDArrayAttribute(objectPath, attributeName);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public double readDouble(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Double> readCallable = new ICallableWithCleanUp<Double>(){

            @Override
            public Double call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                double[] data = new double[1];
                ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public double[] readDoubleArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<double[]> readCallable = new ICallableWithCleanUp<double[]>(){

            @Override
            public double[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                return HDF5DoubleReader.this.readDoubleArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private double[] readDoubleArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            double[] data = new double[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return data;
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readDoubleArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private double[] readDoubleArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        double[] data = new double[HDF5Utils.getOneDimensionalArraySize(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, data.length, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return data;
    }

    @Override
    public int[] readToDoubleMDArrayWithOffset(final String objectPath, final MDDoubleArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DoubleReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                int nativeDataTypeId = HDF5DoubleReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, registry);
                ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToDoubleMDArrayBlockWithOffset(final String objectPath, final MDDoubleArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DoubleReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                int nativeDataTypeId = HDF5DoubleReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, registry);
                ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public double[] readDoubleArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readDoubleArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public double[] readDoubleArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<double[]> readCallable = new ICallableWithCleanUp<double[]>(){

            @Override
            public double[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DoubleReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                double[] data = new double[spaceParams.blockSize];
                ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public double[][] readDoubleMatrix(String objectPath) throws HDF5JavaException {
        MDDoubleArray array = this.readDoubleMDArray(objectPath);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public double[][] readDoubleMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        MDDoubleArray array = this.readDoubleMDArrayBlock(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{blockNumberX, blockNumberY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public double[][] readDoubleMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        MDDoubleArray array = this.readDoubleMDArrayBlockWithOffset(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{offsetX, offsetY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public MDDoubleArray readDoubleMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDDoubleArray> readCallable = new ICallableWithCleanUp<MDDoubleArray>(){

            @Override
            public MDDoubleArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                return HDF5DoubleReader.this.readDoubleMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private MDDoubleArray readDoubleMDArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            double[] data = new double[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return new MDDoubleArray(data, spaceParams.dimensions);
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readDoubleMDArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private MDDoubleArray readDoubleMDArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        double[] data = new double[MDArray.getLength(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_DOUBLE, dimensions, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return new MDDoubleArray(data, dimensions);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readDoubleMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDDoubleArray> readCallable = new ICallableWithCleanUp<MDDoubleArray>(){

            @Override
            public MDDoubleArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.openDataSet(((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DoubleReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                double[] dataBlock = new double[spaceParams.blockSize];
                ((HDF5DoubleReader)HDF5DoubleReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_DOUBLE, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                return new MDDoubleArray(dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<double[]>> getDoubleArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<double[]>>(){

            @Override
            public Iterator<HDF5DataBlock<double[]>> iterator() {
                return new Iterator<HDF5DataBlock<double[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<double[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        double[] block = HDF5DoubleReader.this.readDoubleArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<double[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDDoubleArray>> getDoubleMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDDoubleArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDDoubleArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDDoubleArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDDoubleArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDDoubleArray data = HDF5DoubleReader.this.readDoubleMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDDoubleArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

