/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

public final class HDF5FloatStorageFeatures
extends HDF5AbstractStorageFeatures {
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION = new HDF5FloatStorageFeatures(null, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION_KEEP = new HDF5FloatStorageFeatures(null, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION_DELETE = new HDF5FloatStorageFeatures(null, false, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, false, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, false, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, false, true, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE = new HDF5FloatStorageFeatures(null, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, true, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, false, true, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX = new HDF5FloatStorageFeatures(null, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX_KEEP = new HDF5FloatStorageFeatures(null, true, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX_DELETE = new HDF5FloatStorageFeatures(null, false, true, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1 = new HDF5FloatStorageFeatures(null, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_KEEP = new HDF5FloatStorageFeatures(null, true, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DELETE = new HDF5FloatStorageFeatures(null, false, true, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, true, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, false, true, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2 = new HDF5FloatStorageFeatures(null, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_KEEP = new HDF5FloatStorageFeatures(null, true, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DELETE = new HDF5FloatStorageFeatures(null, false, true, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, true, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, false, true, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3 = new HDF5FloatStorageFeatures(null, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_KEEP = new HDF5FloatStorageFeatures(null, true, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DELETE = new HDF5FloatStorageFeatures(null, false, true, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, true, 6, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, false, true, 6, 3);

    public static HDF5FloatStorageFeatures createFromGeneric(HDF5GenericStorageFeatures storageFeatures) {
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED) {
            return FLOAT_CHUNKED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_DELETE) {
            return FLOAT_CHUNKED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_KEEP) {
            return FLOAT_CHUNKED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT) {
            return FLOAT_COMPACT;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_DELETE) {
            return FLOAT_COMPACT_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_KEEP) {
            return FLOAT_COMPACT_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS) {
            return FLOAT_CONTIGUOUS;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_DELETE) {
            return FLOAT_CONTIGUOUS_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_KEEP) {
            return FLOAT_CONTIGUOUS_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION) {
            return FLOAT_NO_COMPRESSION;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_DELETE) {
            return FLOAT_NO_COMPRESSION_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_KEEP) {
            return FLOAT_NO_COMPRESSION_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE) {
            return FLOAT_DEFLATE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_DELETE) {
            return FLOAT_DEFLATE_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_KEEP) {
            return FLOAT_DEFLATE_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX) {
            return FLOAT_DEFLATE_MAX;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_DELETE) {
            return FLOAT_DEFLATE_MAX_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_KEEP) {
            return FLOAT_DEFLATE_MAX_KEEP;
        }
        return new HDF5FloatStorageFeatures(storageFeatures.tryGetProposedLayout(), storageFeatures.isKeepDataSetIfExists(), storageFeatures.isDeleteDataSetIfExists(), storageFeatures.getDeflateLevel(), -1);
    }

    public static HDF5FloatStorageFeatures createDeflation(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, false, false);
    }

    public static HDF5FloatStorageFeatures createDeflationKeep(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, true, false);
    }

    public static HDF5FloatStorageFeatures createDeflationDelete(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, false, true);
    }

    private static HDF5FloatStorageFeatures createDeflation(int deflationLevel, boolean keepDataSetIfExists, boolean deleteDataSetIfExists) {
        if (deflationLevel == 0) {
            return keepDataSetIfExists ? FLOAT_NO_COMPRESSION_KEEP : FLOAT_NO_COMPRESSION;
        }
        if (deflationLevel == 6) {
            return keepDataSetIfExists ? FLOAT_DEFLATE_KEEP : FLOAT_DEFLATE;
        }
        if (deflationLevel == 9) {
            return keepDataSetIfExists ? FLOAT_DEFLATE_MAX_KEEP : FLOAT_DEFLATE_MAX;
        }
        return new HDF5FloatStorageFeatures(null, keepDataSetIfExists, deleteDataSetIfExists, HDF5FloatStorageFeatures.toByte(deflationLevel), -1);
    }

    public static HDF5FloatStorageFeatures createFloatScaling(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, 0, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createFloatScalingKeep(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, true, 0, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScaling(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, 6, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScalingKeep(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, true, 6, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScaling(int deflateLevel, int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, HDF5FloatStorageFeatures.toByte(deflateLevel), HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScalingKeep(int deflateLevel, int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, true, HDF5FloatStorageFeatures.toByte(deflateLevel), HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, byte deflateLevel, byte scalingFactor) {
        this(proposedLayoutOrNull, false, deflateLevel, scalingFactor);
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, boolean keepDataSetIfExists, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, keepDataSetIfExists, false, deflateLevel, scalingFactor);
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, boolean keepDataSetIfExists, boolean deleteDataSetIfExists, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, keepDataSetIfExists, deleteDataSetIfExists, deflateLevel, scalingFactor);
    }

    boolean isCompatibleWithDataClass(int dataClassId) {
        return dataClassId == HDF5Constants.H5T_FLOAT;
    }
}

