/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5FloatWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5FloatWriter
implements IHDF5FloatWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5FloatWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setFloatAttribute(String objectPath, String name, float value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_IEEE_F32LE, HDF5Constants.H5T_NATIVE_FLOAT, new float[]{value});
    }

    public void setFloatArrayAttribute(final String objectPath, final String name, final float[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_FLOAT, value.length, registry);
                int storageTypeId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F32LE, value.length, registry);
                HDF5FloatWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setFloatMDArrayAttribute(final String objectPath, final String name, final MDFloatArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_FLOAT, value.dimensions(), registry);
                int storageTypeId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_IEEE_F32LE, value.dimensions(), registry);
                HDF5FloatWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setFloatMatrixAttribute(String objectPath, String name, float[][] value) {
        this.setFloatMDArrayAttribute(objectPath, name, new MDFloatArray(value));
    }

    public void writeFloat(String objectPath, float value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_IEEE_F32LE, HDF5Constants.H5T_NATIVE_FLOAT, value);
    }

    public void writeFloatArray(String objectPath, float[] data) {
        this.writeFloatArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeFloatArray(final String objectPath, final float[] data, final HDF5FloatStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5FloatWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F32LE, new long[]{data.length}, 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_FLOAT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createFloatArray(String objectPath, int size) {
        this.createFloatArray(objectPath, size, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatArray(String objectPath, long size, int blockSize) {
        this.createFloatArray(objectPath, size, blockSize, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatArray(final String objectPath, final int size, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, new long[1], new long[]{size}, 4, registry);
                } else {
                    HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, new long[]{size}, null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createFloatArray(final String objectPath, final long size, final int blockSize, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, new long[]{size}, new long[]{blockSize}, 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeFloatArrayBlock(String objectPath, float[] data, long blockNumber) {
        this.writeFloatArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeFloatArrayBlockWithOffset(final String objectPath, final float[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileId, objectPath, ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_FLOAT, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeFloatMatrix(String objectPath, float[][] data) {
        this.writeFloatMatrix(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeFloatMatrix(String objectPath, float[][] data, HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeFloatMDArray(objectPath, new MDFloatArray(data), features);
    }

    public void createFloatMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createFloatMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createFloatMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, dimensions, blockDimensions, 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeFloatMatrixBlock(String objectPath, float[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeFloatMDArrayBlock(objectPath, new MDFloatArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeFloatMatrixBlockWithOffset(String objectPath, float[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeFloatMDArrayBlockWithOffset(objectPath, new MDFloatArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeFloatMatrixBlockWithOffset(String objectPath, float[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeFloatMDArrayBlockWithOffset(objectPath, new MDFloatArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeFloatMDArray(String objectPath, MDFloatArray data) {
        this.writeFloatMDArray(objectPath, data, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void writeFloatMDArray(final String objectPath, final MDFloatArray data, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5FloatWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_IEEE_F32LE, data.longDimensions(), 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_FLOAT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createFloatMDArray(String objectPath, int[] dimensions) {
        this.createFloatMDArray(objectPath, dimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createFloatMDArray(objectPath, dimensions, blockDimensions, HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION);
    }

    public void createFloatMDArray(final String objectPath, final int[] dimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, nullDimensions, MDArray.toLong(dimensions), 4, registry);
                } else {
                    HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, MDArray.toLong(dimensions), null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createFloatMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5FloatStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5FloatWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_IEEE_F32LE, features, dimensions, MDArray.toLong(blockDimensions), 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeFloatMDArrayBlock(String objectPath, MDFloatArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeFloatMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeFloatMDArrayBlockWithOffset(final String objectPath, final MDFloatArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileId, objectPath, ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_FLOAT, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeFloatMDArrayBlockWithOffset(final String objectPath, final MDFloatArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileId, objectPath, ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5FloatWriter)HDF5FloatWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_FLOAT, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

