/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.IHDF5GenericReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5GenericReader
implements IHDF5GenericReader {
    private final HDF5BaseReader baseReader;

    HDF5GenericReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public String tryGetOpaqueTag(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readTagCallable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                return ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.tryGetOpaqueTag(dataTypeId);
            }
        };
        return this.baseReader.runner.call(readTagCallable);
    }

    @Override
    public HDF5OpaqueType tryGetOpaqueType(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5OpaqueType> readTagCallable = new ICallableWithCleanUp<HDF5OpaqueType>(){

            @Override
            public HDF5OpaqueType call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, ((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileRegistry);
                String opaqueTagOrNull = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.tryGetOpaqueTag(dataTypeId);
                if (opaqueTagOrNull == null) {
                    return null;
                }
                return new HDF5OpaqueType(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, dataTypeId, opaqueTagOrNull, HDF5GenericReader.this.baseReader);
            }
        };
        return this.baseReader.runner.call(readTagCallable);
    }

    @Override
    public byte[] readAsByteArray(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5GenericReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                int nativeDataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getNativeDataTypeForDataSetCheckBitFields(dataSetId, registry);
                int elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[spaceParams.blockSize * elementSize];
                ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] getAttributeAsByteArray(final String objectPath, final String attributeName) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int elementSize;
                int numberOfElements;
                int objectId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openObject(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int nativeDataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getNativeDataTypeForAttribute(attributeId, registry);
                int dataClass = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getClassType(nativeDataTypeId);
                if (dataClass == HDF5Constants.H5T_ARRAY) {
                    numberOfElements = MDArray.getLength(((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getArrayDimensions(nativeDataTypeId));
                    int baseDataType = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getBaseDataType(nativeDataTypeId, registry);
                    elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(baseDataType);
                } else {
                    numberOfElements = MDArray.getLength(((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                    elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                }
                return ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, numberOfElements * elementSize);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readAsByteArrayBlock(final String objectPath, final int blockSize, final long blockNumber) throws HDF5JavaException {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5GenericReader.this.baseReader.getSpaceParameters(dataSetId, blockNumber * (long)blockSize, blockSize, registry);
                int nativeDataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                int elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[elementSize * spaceParams.blockSize];
                ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readAsByteArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) throws HDF5JavaException {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5GenericReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                int nativeDataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                int elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[elementSize * spaceParams.blockSize];
                ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int readAsByteArrayToBlockWithOffset(final String objectPath, final byte[] buffer, final int blockSize, final long offset, final int memoryOffset) throws HDF5JavaException {
        if (blockSize + memoryOffset > buffer.length) {
            throw new HDF5JavaException("Buffer not large enough for blockSize and memoryOffset");
        }
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Integer> readCallable = new ICallableWithCleanUp<Integer>(){

            @Override
            public Integer call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.openDataSet(((HDF5GenericReader)HDF5GenericReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5GenericReader.this.baseReader.getSpaceParameters(dataSetId, memoryOffset, offset, blockSize, false, registry);
                int nativeDataTypeId = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                int elementSize = ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                if ((blockSize + memoryOffset) * elementSize > buffer.length) {
                    throw new HDF5JavaException("Buffer not large enough for blockSize and memoryOffset");
                }
                ((HDF5GenericReader)HDF5GenericReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, buffer);
                return spaceParams.blockSize;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getAsByteArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<byte[]>>(){

            @Override
            public Iterator<HDF5DataBlock<byte[]>> iterator() {
                return new Iterator<HDF5DataBlock<byte[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<byte[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        byte[] block = HDF5GenericReader.this.readAsByteArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<byte[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

