/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5LongWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

class HDF5LongWriter
implements IHDF5LongWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5LongWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    public void setLongAttribute(String objectPath, String name, long value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, new long[]{value});
    }

    public void setLongArrayAttribute(final String objectPath, final String name, final long[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, value.length, registry);
                int storageTypeId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, value.length, registry);
                HDF5LongWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    public void setLongMDArrayAttribute(final String objectPath, final String name, final MDLongArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, value.dimensions(), registry);
                int storageTypeId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_I64LE, value.dimensions(), registry);
                HDF5LongWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    public void setLongMatrixAttribute(String objectPath, String name, long[][] value) {
        this.setLongMDArrayAttribute(objectPath, name, new MDLongArray(value));
    }

    public void writeLong(String objectPath, long value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_I64LE, HDF5Constants.H5T_NATIVE_INT64, value);
    }

    public void writeLongArray(String objectPath, long[] data) {
        this.writeLongArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeLongArray(final String objectPath, final long[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5LongWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, new long[]{data.length}, 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createLongArray(String objectPath, int size) {
        this.createLongArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongArray(String objectPath, long size, int blockSize) {
        this.createLongArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createLongArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeLongArrayBlock(String objectPath, long[] data, long blockNumber) {
        this.writeLongArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    public void writeLongArrayBlockWithOffset(final String objectPath, final long[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileId, objectPath, ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeLongMatrix(String objectPath, long[][] data) {
        this.writeLongMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeLongMatrix(String objectPath, long[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeLongMDArray(objectPath, new MDLongArray(data), features);
    }

    public void createLongMatrix(String objectPath, int blockSizeX, int blockSizeY) {
        this.createLongMatrix(objectPath, 0L, 0L, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        this.createLongMatrix(objectPath, sizeX, sizeY, blockSizeX, blockSizeY, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongMatrix(final String objectPath, final long sizeX, final long sizeY, final int blockSizeX, final int blockSizeY, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = new long[]{sizeX, sizeY};
                long[] blockDimensions = new long[]{blockSizeX, blockSizeY};
                HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, dimensions, blockDimensions, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeLongMatrixBlock(String objectPath, long[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeLongMDArrayBlock(objectPath, new MDLongArray(data), new long[]{blockNumberX, blockNumberY});
    }

    public void writeLongMatrixBlockWithOffset(String objectPath, long[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeLongMDArrayBlockWithOffset(objectPath, new MDLongArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    public void writeLongMatrixBlockWithOffset(String objectPath, long[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeLongMDArrayBlockWithOffset(objectPath, new MDLongArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    public void writeLongMDArray(String objectPath, MDLongArray data) {
        this.writeLongMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void writeLongMDArray(final String objectPath, final MDLongArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5LongWriter.this.baseWriter.getOrCreateDataSetId(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, data.longDimensions(), 8, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void createLongMDArray(String objectPath, int[] dimensions) {
        this.createLongMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createLongMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    public void createLongMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, nullDimensions, MDArray.toLong(dimensions), 8, registry);
                } else {
                    HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, MDArray.toLong(dimensions), null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void createLongMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5LongWriter.this.baseWriter.createDataSet(objectPath, features.isSigned() ? HDF5Constants.H5T_STD_I64LE : HDF5Constants.H5T_STD_U64LE, features, dimensions, MDArray.toLong(blockDimensions), 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    public void writeLongMDArrayBlock(String objectPath, MDLongArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeLongMDArrayBlockWithOffset(objectPath, data, offset);
    }

    public void writeLongMDArrayBlockWithOffset(final String objectPath, final MDLongArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileId, objectPath, ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    public void writeLongMDArrayBlockWithOffset(final String objectPath, final MDLongArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileId, objectPath, ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5LongWriter)HDF5LongWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_INT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

