/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5ReferenceWriter
implements IHDF5ReferenceWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5ReferenceWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setObjectReferenceAttribute(String objectPath, String name, String referencedObjectPath) {
        assert (objectPath != null);
        assert (name != null);
        assert (referencedObjectPath != null);
        this.baseWriter.checkOpen();
        byte[] reference = this.baseWriter.h5.createObjectReference(this.baseWriter.fileId, referencedObjectPath);
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_REF_OBJ, HDF5Constants.H5T_STD_REF_OBJ, reference);
    }

    @Override
    public void setObjectReferenceArrayAttribute(final String objectPath, final String name, final String[] referencedObjectPaths) {
        assert (objectPath != null);
        assert (name != null);
        assert (referencedObjectPaths != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int typeId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, referencedObjectPaths.length, registry);
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, referencedObjectPaths);
                HDF5ReferenceWriter.this.baseWriter.setAttribute(objectPath, name, typeId, typeId, references);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setObjectReferenceMDArrayAttribute(final String objectPath, final String name, final MDArray<String> referencedObjectPaths) {
        assert (objectPath != null);
        assert (name != null);
        assert (referencedObjectPaths != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int typeId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, referencedObjectPaths.dimensions(), registry);
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, (String[])referencedObjectPaths.getAsFlatArray());
                HDF5ReferenceWriter.this.baseWriter.setAttribute(objectPath, name, typeId, typeId, references);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void writeObjectReference(String objectPath, String referencedObjectPath) {
        assert (objectPath != null);
        assert (referencedObjectPath != null);
        this.baseWriter.checkOpen();
        byte[] reference = this.baseWriter.h5.createObjectReference(this.baseWriter.fileId, referencedObjectPath);
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_REF_OBJ, HDF5Constants.H5T_STD_REF_OBJ, reference);
    }

    @Override
    public void writeObjectReferenceArray(String objectPath, String[] referencedObjectPath) {
        this.writeObjectReferenceArray(objectPath, referencedObjectPath, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeObjectReferenceArray(final String objectPath, final String[] referencedObjectPaths, final HDF5IntStorageFeatures features) {
        assert (referencedObjectPaths != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, referencedObjectPaths);
                int dataSetId = HDF5ReferenceWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_REF_OBJ, new long[]{referencedObjectPaths.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, references);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createObjectReferenceArray(String objectPath, int size) {
        this.createObjectReferenceArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createLongArray(String objectPath, long size, int blockSize) {
        this.createObjectReferenceArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createObjectReferenceArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createObjectReferenceArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeObjectReferenceArrayBlock(String objectPath, String[] referencedObjectPaths, long blockNumber) {
        this.writeObjectReferenceArrayBlockWithOffset(objectPath, referencedObjectPaths, referencedObjectPaths.length, (long)referencedObjectPaths.length * blockNumber);
    }

    @Override
    public void writeObjectReferenceArrayBlockWithOffset(final String objectPath, final String[] referencedObjectPaths, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (referencedObjectPaths != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, objectPath, ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, referencedObjectPaths);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, references);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeObjectReferenceMDArray(String objectPath, MDArray<String> referencedObjectPaths) {
        this.writeObjectReferenceMDArray(objectPath, referencedObjectPaths, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeObjectReferenceMDArray(final String objectPath, final MDArray<String> referencedObjectPaths, final HDF5IntStorageFeatures features) {
        assert (referencedObjectPaths != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, (String[])referencedObjectPaths.getAsFlatArray());
                int dataSetId = HDF5ReferenceWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_REF_OBJ, referencedObjectPaths.longDimensions(), 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, references);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, int[] dimensions) {
        this.createObjectReferenceMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createObjectReferenceMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createObjectReferenceMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createObjectReferenceMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, nullDimensions, MDArray.toLong(dimensions), 8, registry);
                } else {
                    HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, MDArray.toLong(dimensions), null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createObjectReferenceMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5ReferenceWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_REF_OBJ, features, dimensions, MDArray.toLong(blockDimensions), 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeObjectReferenceMDArrayBlock(String objectPath, MDArray<String> referencedObjectPaths, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = referencedObjectPaths.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeObjectReferenceMDArrayBlockWithOffset(objectPath, referencedObjectPaths, offset);
    }

    @Override
    public void writeObjectReferenceMDArrayBlockWithOffset(final String objectPath, final MDArray<String> referencedObjectPaths, final long[] offset) {
        assert (objectPath != null);
        assert (referencedObjectPaths != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = referencedObjectPaths.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, objectPath, ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                long[] references = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createObjectReferences(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, (String[])referencedObjectPaths.getAsFlatArray());
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, references);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeObjectReferenceMDArrayBlockWithOffset(final String objectPath, final MDLongArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileId, objectPath, ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5ReferenceWriter)HDF5ReferenceWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

