/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.CompoundTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataList;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataMap;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5ValueObjectByteifyer<T> {
    private final HDF5MemberByteifyer[] byteifyers;
    private final int recordSize;
    private Class<?> cachedRecordClass;
    private Constructor<?> cachedDefaultConstructor;

    private static <T> T newMap(int size) {
        return (T)new HDF5CompoundDataMap(size);
    }

    private static <T> T newList(int size) {
        return (T)new HDF5CompoundDataList((Collection<? extends Object>)Collections.nCopies(size, null));
    }

    private static <T> T newArray(int size) {
        return (T)new Object[size];
    }

    HDF5ValueObjectByteifyer(Class<T> clazz, FileInfoProvider fileInfoProvider, CompoundTypeInformation compoundTypeInfoOrNull, HDF5CompoundMemberMapping ... members) {
        this.byteifyers = HDF5CompoundByteifyerFactory.createMemberByteifyers(clazz, fileInfoProvider, compoundTypeInfoOrNull, members);
        this.recordSize = compoundTypeInfoOrNull != null ? compoundTypeInfoOrNull.recordSize : (this.byteifyers.length > 0 ? this.byteifyers[this.byteifyers.length - 1].getTotalSize() : 0);
    }

    public int insertMemberTypes(int dataTypeId) {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            byteifyer.insertType(dataTypeId);
            ++n2;
        }
        return dataTypeId;
    }

    public int insertNativeMemberTypes(int dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            byteifyer.insertNativeType(dataTypeId, h5, registry);
            ++n2;
        }
        return dataTypeId;
    }

    public byte[] byteify(int compoundDataTypeId, T[] arr) throws HDF5JavaException {
        byte[] barray = new byte[arr.length * this.recordSize];
        int offset = 0;
        int counter = 0;
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
            int n3 = this.byteifyers.length;
            int n4 = 0;
            while (n4 < n3) {
                HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n4];
                try {
                    byte[] b = byteifyer.byteify(compoundDataTypeId, obj);
                    if (b.length > byteifyer.getSizeInBytes()) {
                        throw new HDF5JavaException("Compound " + byteifyer.describe() + " of array element " + counter + " must not exceed " + byteifyer.getSizeInBytes() + " bytes, but is of size " + b.length + " bytes.");
                    }
                    System.arraycopy(b, 0, barray, offset + byteifyer.getOffset(), b.length);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new HDF5JavaException("Error accessing " + byteifyer.describe());
                }
                ++n4;
            }
            offset += this.recordSize;
            ++counter;
            ++n2;
        }
        return barray;
    }

    public byte[] byteify(int compoundDataTypeId, T obj) throws HDF5JavaException {
        byte[] barray = new byte[this.recordSize];
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            try {
                byte[] b = byteifyer.byteify(compoundDataTypeId, obj);
                if (b.length > byteifyer.getSizeInBytes()) {
                    throw new HDF5JavaException("Compound " + byteifyer.describe() + " must not exceed " + byteifyer.getSizeInBytes() + " bytes, but is of size " + b.length + " bytes.");
                }
                System.arraycopy(b, 0, barray, byteifyer.getOffset(), b.length);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HDF5JavaException("Error accessing " + byteifyer.describe());
            }
            ++n2;
        }
        return barray;
    }

    public T[] arrayify(int compoundDataTypeId, byte[] byteArr, Class<T> recordClass) {
        int length = byteArr.length / this.recordSize;
        if (length * this.recordSize != byteArr.length) {
            throw new HDF5JavaException("Illegal byte array for compound type (length " + byteArr.length + " is not a multiple of record size " + this.recordSize + ")");
        }
        T[] result = HDF5Utils.createArray(recordClass, length);
        int offset = 0;
        int i = 0;
        while (i < length) {
            result[i] = this.primArrayifyScalar(compoundDataTypeId, byteArr, recordClass, offset);
            offset += this.recordSize;
            ++i;
        }
        return result;
    }

    public T arrayifyScalar(int compoundDataTypeId, byte[] byteArr, Class<T> recordClass) {
        if (byteArr.length < this.recordSize) {
            throw new HDF5JavaException("Illegal byte array for scalar compound type (length " + byteArr.length + " is smaller than record size " + this.recordSize + ")");
        }
        return this.primArrayifyScalar(compoundDataTypeId, byteArr, recordClass, 0);
    }

    private T primArrayifyScalar(int compoundDataTypeId, byte[] byteArr, Class<T> recordClass, int offset) {
        T result = this.newInstance(recordClass);
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            try {
                byteifyer.setFromByteArray(compoundDataTypeId, result, byteArr, offset);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HDF5JavaException("Error accessing " + byteifyer.describe());
            }
            ++n2;
        }
        return result;
    }

    private T newInstance(Class<?> recordClass) throws HDF5JavaException {
        if (Map.class.isAssignableFrom(recordClass)) {
            return HDF5ValueObjectByteifyer.newMap(this.byteifyers.length);
        }
        if (List.class.isAssignableFrom(recordClass)) {
            return HDF5ValueObjectByteifyer.newList(this.byteifyers.length);
        }
        if (recordClass == Object[].class) {
            return HDF5ValueObjectByteifyer.newArray(this.byteifyers.length);
        }
        try {
            if (recordClass != this.cachedRecordClass) {
                this.cachedRecordClass = recordClass;
                this.cachedDefaultConstructor = ReflectionUtils.getDefaultConstructor(recordClass);
            }
            return (T)this.cachedDefaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new HDF5JavaException("Creation of new object of class " + recordClass.getCanonicalName() + " by default constructor failed: " + ex.toString());
        }
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public HDF5MemberByteifyer[] getByteifyers() {
        return this.byteifyers;
    }

    public boolean hasUnmappedMembers() {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer memberByteifyer = hDF5MemberByteifyerArray[n2];
            if (memberByteifyer.isDummy()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getUnmappedMembers() {
        if (this.hasUnmappedMembers()) {
            ArrayList<String> unmappedMembers = new ArrayList<String>();
            HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
            int n = this.byteifyers.length;
            int n2 = 0;
            while (n2 < n) {
                HDF5MemberByteifyer memberByteifyer = hDF5MemberByteifyerArray[n2];
                if (memberByteifyer.isDummy()) {
                    unmappedMembers.add(memberByteifyer.getMemberName());
                }
                ++n2;
            }
            return unmappedMembers.toArray(new String[unmappedMembers.size()]);
        }
        return new String[0];
    }

    public String toString() {
        return "HDF5ValueObjectByteifyer [byteifyers=" + Arrays.toString(this.byteifyers) + "]";
    }

    static interface FileInfoProvider {
        public int getBooleanDataTypeId();

        public int getStringDataTypeId(int var1);

        public int getArrayTypeId(int var1, int var2);

        public int getArrayTypeId(int var1, int[] var2);

        public HDF5EnumerationType getEnumType(String[] var1);

        public CharacterEncoding getCharacterEncoding();
    }
}

