/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryCompleteness;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.Utils;

public final class ArchiveEntry {
    private final String path;
    private final String parentPath;
    private final String name;
    private final ArchiveEntryCompleteness completeness;
    private final boolean hasLinkTarget;
    private final String linkTarget;
    private final FileLinkType linkType;
    private final FileLinkType verifiedLinkType;
    private final long size;
    private final long verifiedSize;
    private final long lastModified;
    private final int crc32;
    private final int verifiedCrc32;
    private final int uid;
    private final int gid;
    private final IdCache idCache;
    private final short permissions;
    private final String errorLineOrNull;

    ArchiveEntry(String dir, String path, LinkRecord link, IdCache idCache) {
        this(dir, path, link, idCache, null);
    }

    ArchiveEntry(String dir, String path, LinkRecord link, IdCache idCache, String errorLineOrNull) {
        this.parentPath = dir;
        this.path = path;
        this.name = link.getLinkName();
        this.idCache = idCache;
        this.completeness = link.getCompleteness();
        this.hasLinkTarget = link.tryGetLinkTarget() != null;
        this.linkTarget = this.hasLinkTarget ? link.tryGetLinkTarget() : "?";
        this.linkType = link.getLinkType();
        this.verifiedLinkType = link.getVerifiedType();
        this.size = link.getSize();
        this.verifiedSize = link.getVerifiedSize();
        this.lastModified = link.getLastModified();
        this.crc32 = link.getCrc32();
        this.verifiedCrc32 = link.getVerifiedCrc32();
        this.uid = link.getUid();
        this.gid = link.getGid();
        this.permissions = link.getPermissions();
        this.errorLineOrNull = errorLineOrNull;
    }

    ArchiveEntry(String errorLineOrNull) {
        this.errorLineOrNull = errorLineOrNull;
        this.path = null;
        this.parentPath = null;
        this.name = null;
        this.idCache = null;
        this.completeness = null;
        this.linkTarget = null;
        this.hasLinkTarget = false;
        this.linkType = null;
        this.verifiedLinkType = null;
        this.size = -1L;
        this.verifiedSize = -1L;
        this.lastModified = -1L;
        this.crc32 = 0;
        this.verifiedCrc32 = 0;
        this.uid = 0;
        this.gid = 0;
        this.permissions = 0;
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getName() {
        return this.name;
    }

    public ArchiveEntryCompleteness getCompleteness() {
        return this.completeness;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public boolean hasLinkTarget() {
        return this.hasLinkTarget;
    }

    public FileLinkType getLinkType() {
        return this.linkType;
    }

    public boolean isDirectory() {
        return this.linkType == FileLinkType.DIRECTORY;
    }

    public boolean isSymLink() {
        return this.linkType == FileLinkType.SYMLINK;
    }

    public boolean isRegularFile() {
        return this.linkType == FileLinkType.REGULAR_FILE;
    }

    public FileLinkType tryGetVerifiedLinkType() {
        return this.verifiedLinkType;
    }

    public long getSize() {
        return this.size;
    }

    public long getVerifiedSize() {
        return this.verifiedSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public String getCrc32Str() {
        return Utils.crc32ToString(this.crc32);
    }

    public int getVerifiedCrc32() {
        return this.verifiedCrc32;
    }

    public String getVerifiedCrc32Str() {
        return Utils.crc32ToString(this.verifiedCrc32);
    }

    public String getUser(boolean numeric) {
        return this.idCache.getUser(this.uid, numeric);
    }

    public int getUid() {
        return this.uid;
    }

    public String getGroup(boolean numeric) {
        return this.idCache.getGroup(this.gid, numeric);
    }

    public int getGid() {
        return this.gid;
    }

    public short getPermissions() {
        return this.permissions;
    }

    public String getPermissionsString(boolean numeric) {
        return Utils.permissionsToString(this.permissions, this.linkType == FileLinkType.DIRECTORY, numeric);
    }

    public String getErrorLineOrNull() {
        return this.errorLineOrNull;
    }

    public boolean hasCheck() {
        return this.verifiedLinkType != null || this.verifiedSize != -1L || this.verifiedCrc32 != 0 || this.errorLineOrNull != null;
    }

    public boolean isOK() {
        return this.errorLineOrNull == null && this.linkTypeOK() && this.sizeOK() && this.checksumOK();
    }

    public boolean linkTypeOK() {
        return this.verifiedLinkType == null || this.linkType == this.verifiedLinkType;
    }

    public boolean sizeOK() {
        return this.verifiedSize == -1L || this.size == this.verifiedSize;
    }

    public boolean checksumOK() {
        return this.verifiedSize == -1L || this.crc32 == this.verifiedCrc32;
    }

    public String getStatus(boolean verbose) {
        if (!this.isOK()) {
            if (this.errorLineOrNull != null) {
                return "ERROR: " + this.errorLineOrNull;
            }
            if (!this.linkTypeOK()) {
                return verbose ? String.format("ERROR: link type mismatch [expected: %s, found: %s]", this.linkType, this.verifiedLinkType) : "WRONG TYPE";
            }
            if (!this.sizeOK()) {
                return verbose ? String.format("ERROR: size mismatch [expected: %d, found: %d]", this.size, this.verifiedSize) : "WRONG SIZE";
            }
            if (!this.checksumOK()) {
                return verbose ? String.format("ERROR: checksum mismatch [expected: %s, found: %s]", Utils.crc32ToString(this.crc32), Utils.crc32ToString(this.verifiedCrc32)) : "WRONG CRC32";
            }
        }
        return "OK";
    }

    public String describeLink() {
        return this.describeLink(true, false, true);
    }

    public String describeLink(boolean verbose) {
        return this.describeLink(verbose, false, true);
    }

    public String describeLink(boolean verbose, boolean numeric) {
        return this.describeLink(verbose, numeric, true);
    }

    public String describeLink(boolean verbose, boolean numeric, boolean includeCheck) {
        StringBuilder builder = new StringBuilder();
        if (!verbose) {
            builder.append(this.path);
        } else {
            switch (this.completeness) {
                case BASE: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("          \t%s -> %s", this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("       DIR\t%s", this.path));
                        break;
                    }
                    builder.append(String.format("%10d\t%s\t%s%s", this.size, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                case LAST_MODIFIED: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("          \t%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS\t%2$s -> %3$s", this.lastModified * 1000L, this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("       DIR\t%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS\t%2$s", this.lastModified * 1000L, this.path));
                        break;
                    }
                    builder.append(String.format("%10d\t%2$tY-%2$tm-%2$td %2$tH:%2$tM:%2$tS\t%3$s\t%4$s%5$s", this.size, this.lastModified * 1000L, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                case FULL: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("%s\t%s\t%s\t          \t%4$tY-%4$tm-%4$td %4$tH:%4$tM:%4$tS\t        \t%5$s -> %6$s", Utils.permissionsToString(this.permissions, false, numeric), this.getUser(numeric), this.getGroup(numeric), this.lastModified * 1000L, this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("%s\t%s\t%s\t       DIR\t%4$tY-%4$tm-%4$td %4$tH:%4$tM:%4$tS\t        \t%5$s", Utils.permissionsToString(this.permissions, true, numeric), this.getUser(numeric), this.getGroup(numeric), this.lastModified * 1000L, this.path));
                        break;
                    }
                    builder.append(String.format("%s\t%s\t%s\t%10d\t%5$tY-%5$tm-%5$td %5$tH:%5$tM:%5$tS\t%6$s\t%7$s%8$s", Utils.permissionsToString(this.permissions, false, numeric), this.getUser(numeric), this.getGroup(numeric), this.size, this.lastModified * 1000L, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                default: {
                    throw new Error("Unknown level of link completeness: " + (Object)((Object)this.completeness));
                }
            }
        }
        if (includeCheck && this.hasCheck()) {
            builder.append('\t');
            builder.append(this.getStatus(false));
        }
        return builder.toString();
    }

    public String toString() {
        return this.describeLink();
    }
}

