/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryProcessor;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.io.File;
import java.io.IOException;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

class HDF5ArchiveTraverser {
    private final IHDF5Reader hdf5Reader;
    private final DirectoryIndexProvider indexProvider;
    private final IErrorStrategy errorStrategy;
    private final IdCache idCache;

    public HDF5ArchiveTraverser(IHDF5Reader hdf5Reader, DirectoryIndexProvider indexProvider, IdCache idCache) {
        this.hdf5Reader = hdf5Reader;
        this.indexProvider = indexProvider;
        this.errorStrategy = indexProvider.getErrorStrategy();
        this.idCache = idCache;
    }

    public void process(String fileOrDir, boolean recursive, boolean readLinkTargets, IArchiveEntryProcessor processor) {
        String normalizedPath = Utils.normalizePath(fileOrDir);
        boolean isDirectory = this.hdf5Reader.isGroup(normalizedPath, false);
        String parentPath = Utils.getParentPath(normalizedPath);
        LinkRecord link = null;
        if (parentPath.length() > 0) {
            link = this.indexProvider.get(parentPath, readLinkTargets).tryGetLink(normalizedPath.substring(parentPath.length() + 1));
            if (link == null) {
                this.errorStrategy.dealWithError(processor.createException(normalizedPath, "Object not found in archive."));
                return;
            }
            try {
                if (!processor.process(parentPath, normalizedPath, link, this.hdf5Reader, this.idCache, this.errorStrategy)) {
                    return;
                }
            }
            catch (IOException ex) {
                File f = new File(normalizedPath);
                this.errorStrategy.dealWithError(processor.createException(f, ex));
            }
            catch (HDF5Exception ex) {
                this.errorStrategy.dealWithError(processor.createException(normalizedPath, ex));
            }
        }
        if (isDirectory) {
            this.processDirectory(normalizedPath, recursive, readLinkTargets, processor);
            this.postProcessDirectory(parentPath, normalizedPath, link, processor);
        }
    }

    private void postProcessDirectory(String parentPath, String normalizedPath, LinkRecord linkOrNull, IArchiveEntryProcessor processor) {
        if (linkOrNull != null) {
            try {
                processor.postProcessDirectory(parentPath, normalizedPath, linkOrNull, this.hdf5Reader, this.idCache, this.errorStrategy);
            }
            catch (IOException ex) {
                File f = new File(normalizedPath);
                this.errorStrategy.dealWithError(processor.createException(f, ex));
            }
            catch (HDF5Exception ex) {
                this.errorStrategy.dealWithError(processor.createException(normalizedPath, ex));
            }
        }
    }

    private void processDirectory(String normalizedDir, boolean recursive, boolean readLinkTargets, IArchiveEntryProcessor processor) {
        if (!this.hdf5Reader.exists(normalizedDir, false)) {
            this.errorStrategy.dealWithError(processor.createException(normalizedDir, "Directory not found in archive."));
            return;
        }
        for (LinkRecord link : this.indexProvider.get(normalizedDir, readLinkTargets)) {
            String path = String.valueOf("/".equals(normalizedDir) ? "/" : String.valueOf(normalizedDir) + "/") + link.getLinkName();
            try {
                if (!processor.process(normalizedDir, path, link, this.hdf5Reader, this.idCache, this.errorStrategy) || !recursive || !link.isDirectory()) continue;
                this.processDirectory(path, recursive, readLinkTargets, processor);
                this.postProcessDirectory(normalizedDir, path, link, processor);
            }
            catch (IOException ex) {
                File f = new File(path);
                this.errorStrategy.dealWithError(processor.createException(f, ex));
            }
            catch (HDF5Exception ex) {
                this.errorStrategy.dealWithError(processor.createException(path, ex));
            }
        }
    }
}

