/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.AdapterIOutputStreamToOutputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IOutputStream;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5FactoryProvider;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryExtractProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryListProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryVerifyProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingStrategy;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveDeleter;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveTraverser;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveUpdater;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5ArchiveInfoProvider;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5Archiver;
import ch.systemsx.cisd.hdf5.h5ar.IListEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IPathVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.ListParameters;
import ch.systemsx.cisd.hdf5.h5ar.NewArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.UnarchivingException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import ch.systemsx.cisd.hdf5.h5ar.VerifyParameters;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HDF5Archiver
implements Closeable,
Flushable,
IHDF5Archiver,
IHDF5ArchiveInfoProvider {
    public static final int CHUNK_SIZE_AUTO = -1;
    private static final int MB = 0x100000;
    static final int BUFFER_SIZE = 0xA00000;
    private final IHDF5Reader hdf5Reader;
    private final IHDF5Writer hdf5WriterOrNull;
    private final boolean closeReaderOnCloseFile;
    private final IErrorStrategy errorStrategy;
    private final DirectoryIndexProvider indexProvider;
    private final byte[] buffer = new byte[0xA00000];
    private final HDF5ArchiveUpdater updaterOrNull;
    private final HDF5ArchiveDeleter deleterOrNull;
    private final HDF5ArchiveTraverser processor;
    private final IdCache idCache;

    static IHDF5Reader createHDF5Reader(File archiveFile) {
        return HDF5FactoryProvider.get().configureForReading(archiveFile).useUTF8CharacterEncoding().reader();
    }

    static IHDF5Writer createHDF5Writer(File archiveFile, IHDF5WriterConfigurator.FileFormat fileFormat, boolean noSync) {
        IHDF5WriterConfigurator config = HDF5FactoryProvider.get().configure(archiveFile);
        config.fileFormat(fileFormat);
        config.useUTF8CharacterEncoding();
        if (!noSync) {
            config.syncMode(IHDF5WriterConfigurator.SyncMode.SYNC);
        }
        return config.writer();
    }

    HDF5Archiver(File archiveFile, boolean readOnly) {
        this(archiveFile, readOnly, false, IHDF5WriterConfigurator.FileFormat.STRICTLY_1_6, null);
    }

    HDF5Archiver(File archiveFile, boolean readOnly, boolean noSync, IHDF5WriterConfigurator.FileFormat fileFormat, IErrorStrategy errorStrategyOrNull) {
        this.closeReaderOnCloseFile = true;
        this.hdf5WriterOrNull = readOnly ? null : HDF5Archiver.createHDF5Writer(archiveFile, fileFormat, noSync);
        this.hdf5Reader = this.hdf5WriterOrNull != null ? this.hdf5WriterOrNull : HDF5Archiver.createHDF5Reader(archiveFile);
        this.errorStrategy = errorStrategyOrNull == null ? IErrorStrategy.DEFAULT_ERROR_STRATEGY : errorStrategyOrNull;
        this.indexProvider = new DirectoryIndexProvider(this.hdf5Reader, this.errorStrategy);
        this.idCache = new IdCache();
        this.processor = new HDF5ArchiveTraverser(this.hdf5Reader, this.indexProvider, this.idCache);
        if (this.hdf5WriterOrNull == null) {
            this.updaterOrNull = null;
            this.deleterOrNull = null;
        } else {
            this.updaterOrNull = new HDF5ArchiveUpdater(this.hdf5WriterOrNull, this.indexProvider, this.buffer);
            this.deleterOrNull = new HDF5ArchiveDeleter(this.hdf5WriterOrNull, this.indexProvider);
        }
    }

    HDF5Archiver(IHDF5Reader reader, boolean enforceReadOnly, IErrorStrategy errorStrategyOrNull) {
        this.closeReaderOnCloseFile = false;
        this.hdf5WriterOrNull = !enforceReadOnly && reader instanceof IHDF5Writer ? (IHDF5Writer)reader : null;
        this.errorStrategy = errorStrategyOrNull == null ? IErrorStrategy.DEFAULT_ERROR_STRATEGY : errorStrategyOrNull;
        this.hdf5Reader = reader;
        this.indexProvider = new DirectoryIndexProvider(this.hdf5Reader, this.errorStrategy);
        this.idCache = new IdCache();
        this.processor = new HDF5ArchiveTraverser(this.hdf5Reader, this.indexProvider, this.idCache);
        if (this.hdf5WriterOrNull == null) {
            this.updaterOrNull = null;
            this.deleterOrNull = null;
        } else {
            this.updaterOrNull = new HDF5ArchiveUpdater(this.hdf5WriterOrNull, this.indexProvider, this.buffer);
            this.deleterOrNull = new HDF5ArchiveDeleter(this.hdf5WriterOrNull, this.indexProvider);
        }
    }

    @Override
    public void close() {
        this.flush();
        if (this.closeReaderOnCloseFile) {
            this.hdf5Reader.close();
        } else {
            this.indexProvider.close();
        }
    }

    @Override
    public void flush() {
        if (this.hdf5WriterOrNull != null) {
            this.hdf5WriterOrNull.flush();
        }
    }

    @Override
    public boolean exists(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = normalizedPath.substring(parentPath.length() + 1);
        return this.indexProvider.get(parentPath, false).exists(name);
    }

    @Override
    public boolean isDirectory(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = normalizedPath.substring(parentPath.length() + 1);
        return this.indexProvider.get(parentPath, false).isDirectory(name);
    }

    @Override
    public boolean isRegularFile(String path) {
        return HDF5Archiver.isRegularFile(this.tryGetLink(path, false));
    }

    @Override
    public boolean isSymLink(String path) {
        return HDF5Archiver.isSymLink(this.tryGetLink(path, false));
    }

    @Override
    public ArchiveEntry tryGetEntry(String path, boolean readLinkTarget) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = normalizedPath.substring(parentPath.length() + 1);
        return HDF5Archiver.trytoArchiveEntry(parentPath, normalizedPath, this.indexProvider.get(parentPath, readLinkTarget).tryGetLink(name), this.idCache);
    }

    private LinkRecord tryGetLink(String path, boolean readLinkTargets) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = normalizedPath.substring(parentPath.length() + 1);
        return this.indexProvider.get(parentPath, readLinkTargets).tryGetLink(name);
    }

    private static boolean isRegularFile(LinkRecord linkOrNull) {
        return linkOrNull != null && linkOrNull.isRegularFile();
    }

    private static boolean isSymLink(LinkRecord linkOrNull) {
        return linkOrNull != null && linkOrNull.isSymLink();
    }

    private static ArchiveEntry trytoArchiveEntry(String dir, String path, LinkRecord linkOrNull, IdCache idCache) {
        return linkOrNull != null ? new ArchiveEntry(dir, path, linkOrNull, idCache) : null;
    }

    @Override
    public List<ArchiveEntry> list(String fileOrDir) {
        return this.list(fileOrDir, ListParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> list(String fileOrDir, final ListParameters params) {
        final ArrayList<ArchiveEntry> result = new ArrayList<ArchiveEntry>(100);
        this.list(fileOrDir, new IListEntryVisitor(){

            public void visit(ArchiveEntry entry) {
                if (!params.isSuppressDirectoryEntries() || !entry.isDirectory()) {
                    result.add(entry);
                }
            }
        }, params);
        return result;
    }

    @Override
    public List<ArchiveEntry> test() {
        final ArrayList<ArchiveEntry> result = new ArrayList<ArchiveEntry>(100);
        this.list("/", new IListEntryVisitor(){

            public void visit(ArchiveEntry entry) {
                if (!entry.isOK()) {
                    result.add(entry);
                }
            }
        }, ListParameters.TEST);
        return result;
    }

    @Override
    public IHDF5Archiver list(String fileOrDir, IListEntryVisitor visitor) {
        return this.list(fileOrDir, visitor, ListParameters.DEFAULT);
    }

    @Override
    public IHDF5Archiver list(String fileOrDir, final IListEntryVisitor visitor, ListParameters params) {
        ArchiveEntryListProcessor listProcessor = new ArchiveEntryListProcessor(params.isSuppressDirectoryEntries() ? new IListEntryVisitor(){

            public void visit(ArchiveEntry entry) {
                if (!entry.isDirectory()) {
                    visitor.visit(entry);
                }
            }
        } : visitor, this.buffer, params.isTestArchive());
        this.processor.process(fileOrDir, params.isRecursive(), params.isReadLinkTargets(), listProcessor);
        return this;
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String rootDirectory) {
        return this.verifyAgainstFilesystem("/", rootDirectory, VerifyParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, String rootDirectory) {
        return this.verifyAgainstFilesystem(fileOrDir, rootDirectory, VerifyParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, String rootDirectory, VerifyParameters params) {
        final ArrayList<ArchiveEntry> verifyErrors = new ArrayList<ArchiveEntry>();
        this.verifyAgainstFilesystem(fileOrDir, rootDirectory, new IListEntryVisitor(){

            public void visit(ArchiveEntry entry) {
                if (!entry.isOK()) {
                    verifyErrors.add(entry);
                }
            }
        }, params);
        return verifyErrors;
    }

    @Override
    public IHDF5Archiver verifyAgainstFilesystem(String fileOrDir, String rootDirectory, IListEntryVisitor visitor) {
        return this.verifyAgainstFilesystem(fileOrDir, rootDirectory, visitor, VerifyParameters.DEFAULT);
    }

    @Override
    public IHDF5Archiver verifyAgainstFilesystem(String fileOrDir, String rootDirectory, IListEntryVisitor visitor, VerifyParameters params) {
        ArchiveEntryVerifyProcessor verifyProcessor = new ArchiveEntryVerifyProcessor(visitor, rootDirectory, this.buffer, params.isVerifyAttributes(), params.isNumeric());
        this.processor.process(fileOrDir, params.isRecursive(), params.isReadLinkTargets(), verifyProcessor);
        return this;
    }

    @Override
    public IHDF5Archiver extractFile(String path, OutputStream out) throws IOExceptionUnchecked {
        if (!this.hdf5Reader.isDataSet(path)) {
            this.errorStrategy.dealWithError(new UnarchivingException(path, "not found in archive"));
            return this;
        }
        try {
            for (HDF5DataBlock<byte[]> block : this.hdf5Reader.getAsByteArrayNaturalBlocks(path)) {
                out.write(block.getData());
            }
        }
        catch (IOException ex) {
            this.errorStrategy.dealWithError(new UnarchivingException(new File("stdout"), ex));
        }
        return this;
    }

    @Override
    public byte[] extractFileAsByteArray(String path) throws IOExceptionUnchecked {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.extractFile(path, out);
        return out.toByteArray();
    }

    @Override
    public IInputStream extractFileAsIInputStream(String path) {
        if (!this.hdf5Reader.isDataSet(path)) {
            this.errorStrategy.dealWithError(new UnarchivingException(path, "not found in archive"));
            return null;
        }
        return HDF5IOAdapterFactory.asIInputStream(this.hdf5Reader, path);
    }

    @Override
    public InputStream extractFileAsInputStream(String path) {
        return new AdapterIInputStreamToInputStream(this.extractFileAsIInputStream(path));
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File root, String path) throws IllegalStateException {
        return this.extractToFilesystem(root, path, ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File root, String path, IListEntryVisitor visitorOrNull) throws IllegalStateException {
        return this.extractToFilesystem(root, path, ArchivingStrategy.DEFAULT, visitorOrNull);
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File root, String path, ArchivingStrategy strategy, IListEntryVisitor visitorOrNull) throws IllegalStateException {
        ArchiveEntryExtractProcessor extractor = new ArchiveEntryExtractProcessor(visitorOrNull, strategy, root.getAbsolutePath(), this.buffer);
        this.processor.process(path, true, true, extractor);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path) throws IllegalStateException {
        return this.archiveFromFilesystem(path, ArchivingStrategy.DEFAULT, false, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, ArchivingStrategy strategy) throws IllegalStateException {
        return this.archiveFromFilesystem(path, strategy, false, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, IPathVisitor pathVisitorOrNull) throws IllegalStateException {
        return this.archiveFromFilesystem(path, ArchivingStrategy.DEFAULT, false, pathVisitorOrNull);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, ArchivingStrategy strategy, boolean keepNameFromPath, IPathVisitor pathVisitorOrNull) throws IllegalStateException {
        this.checkReadWrite();
        this.updaterOrNull.archive(path, strategy, -1, keepNameFromPath, pathVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File root, File path) throws IllegalStateException {
        return this.archiveFromFilesystem(root, path, ArchivingStrategy.DEFAULT);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File root, File path, ArchivingStrategy strategy) throws IllegalStateException {
        return this.archiveFromFilesystem(root, path, strategy, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File root, File path, ArchivingStrategy strategy, IPathVisitor pathVisitorOrNull) throws IllegalStateException {
        this.checkReadWrite();
        this.updaterOrNull.archive(root, path, strategy, -1, pathVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFile(String path, byte[] data) throws IllegalStateException {
        return this.archiveFile(NewArchiveEntry.file(path), new ByteArrayInputStream(data), null);
    }

    @Override
    public IHDF5Archiver archiveFile(String path, InputStream input) {
        return this.archiveFile(NewArchiveEntry.file(path), input, null);
    }

    @Override
    public IHDF5Archiver archiveFile(NewArchiveEntry.NewFileArchiveEntry entry, InputStream input) {
        return this.archiveFile(entry, input, null);
    }

    @Override
    public IHDF5Archiver archiveFile(NewArchiveEntry.NewFileArchiveEntry entry, byte[] data) {
        return this.archiveFile(entry, new ByteArrayInputStream(data), null);
    }

    @Override
    public OutputStream archiveFileAsOutputStream(NewArchiveEntry.NewFileArchiveEntry entry) {
        return new AdapterIOutputStreamToOutputStream(this.archiveFileAsIOutputStream(entry));
    }

    @Override
    public IOutputStream archiveFileAsIOutputStream(NewArchiveEntry.NewFileArchiveEntry entry) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        IOutputStream stream = this.updaterOrNull.archiveFile(entry.getParentPath(), link, entry.isCompress(), entry.getChunkSize());
        return stream;
    }

    @Override
    public IHDF5Archiver archiveFile(NewArchiveEntry.NewFileArchiveEntry entry, InputStream input, IPathVisitor pathVisitorOrNull) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, input, entry.isCompress(), entry.getChunkSize(), pathVisitorOrNull);
        entry.setCrc32(link.getCrc32());
        return this;
    }

    @Override
    public IHDF5Archiver archiveSymlink(NewArchiveEntry.NewSymLinkArchiveEntry entry) {
        return this.archiveSymlink(entry, null);
    }

    @Override
    public IHDF5Archiver archiveSymlink(String path, String linkTarget) {
        return this.archiveSymlink(NewArchiveEntry.symlink(path, linkTarget), null);
    }

    @Override
    public IHDF5Archiver archiveSymlink(NewArchiveEntry.NewSymLinkArchiveEntry entry, IPathVisitor pathVisitorOrNull) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, null, false, -1, pathVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveDirectory(String path) {
        return this.archiveDirectory(NewArchiveEntry.directory(path), null);
    }

    @Override
    public IHDF5Archiver archiveDirectory(NewArchiveEntry.NewDirectoryArchiveEntry entry) {
        return this.archiveDirectory(entry, null);
    }

    @Override
    public IHDF5Archiver archiveDirectory(NewArchiveEntry.NewDirectoryArchiveEntry entry, IPathVisitor pathVisitorOrNull) throws IllegalStateException, IllegalArgumentException {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, null, false, -1, pathVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver delete(String hdf5ObjectPath) {
        return this.delete(Collections.singletonList(hdf5ObjectPath), null);
    }

    @Override
    public IHDF5Archiver delete(List<String> hdf5ObjectPaths) {
        return this.delete(hdf5ObjectPaths, null);
    }

    @Override
    public IHDF5Archiver delete(List<String> hdf5ObjectPaths, IPathVisitor pathVisitorOrNull) {
        this.checkReadWrite();
        this.deleterOrNull.delete(hdf5ObjectPaths, pathVisitorOrNull);
        return this;
    }

    private void checkReadWrite() {
        if (this.updaterOrNull == null) {
            throw new IllegalStateException("Cannot update archive in read-only mode.");
        }
    }
}

