/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LinkStore
implements Iterable<LinkRecord> {
    private Map<String, LinkRecord> linkMap;
    private LinkRecord[] sortedArrayOrNull;
    private boolean linkMapPopulated = false;

    LinkStore() {
        this(new LinkRecord[0]);
    }

    LinkStore(LinkRecord[] sortedEntries) {
        this.sortedArrayOrNull = sortedEntries;
    }

    private Map<String, LinkRecord> getLinkMap() {
        if (!this.linkMapPopulated && this.sortedArrayOrNull != null) {
            this.linkMap = new HashMap<String, LinkRecord>(this.sortedArrayOrNull.length);
            LinkRecord[] linkRecordArray = this.sortedArrayOrNull;
            int n = this.sortedArrayOrNull.length;
            int n2 = 0;
            while (n2 < n) {
                LinkRecord entry = linkRecordArray[n2];
                this.linkMap.put(entry.getLinkName(), entry);
                ++n2;
            }
            this.linkMapPopulated = true;
        }
        return this.linkMap;
    }

    public LinkRecord[] getLinkArray() {
        if (this.sortedArrayOrNull == null) {
            this.sortedArrayOrNull = this.getLinkMap().values().toArray(new LinkRecord[this.getLinkMap().size()]);
            Arrays.sort(this.sortedArrayOrNull);
        }
        return this.sortedArrayOrNull;
    }

    public void amendLinkTargets(IHDF5Reader reader, String groupPath) {
        for (LinkRecord link : this.getLinkMap().values()) {
            link.addLinkTarget(reader, groupPath);
        }
    }

    public LinkRecord tryGetLink(String name) {
        return this.getLinkMap().get(name);
    }

    public boolean exists(String name) {
        return this.tryGetLink(name) != null;
    }

    public boolean isEmpty() {
        return this.getLinkMap().isEmpty();
    }

    @Override
    public Iterator<LinkRecord> iterator() {
        LinkRecord[] list;
        LinkRecord[] linkRecordArray = list = this.getLinkArray();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            LinkRecord link = linkRecordArray[n2];
            link.resetVerification();
            ++n2;
        }
        return Arrays.asList(list).iterator();
    }

    public void update(LinkRecord entry) {
        this.getLinkMap().put(entry.getLinkName(), entry);
        this.sortedArrayOrNull = null;
    }

    public void update(LinkRecord[] entries) {
        LinkRecord[] linkRecordArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            LinkRecord entry = linkRecordArray[n2];
            this.getLinkMap().put(entry.getLinkName(), entry);
            ++n2;
        }
        if (entries.length > 0) {
            this.sortedArrayOrNull = null;
        }
    }

    public void update(Collection<LinkRecord> entries) {
        for (LinkRecord entry : entries) {
            this.getLinkMap().put(entry.getLinkName(), entry);
        }
        if (entries.size() > 0) {
            this.sortedArrayOrNull = null;
        }
    }

    public boolean remove(String linkName) {
        boolean storeChanged;
        boolean bl = storeChanged = this.getLinkMap().remove(linkName) != null;
        if (storeChanged) {
            this.sortedArrayOrNull = null;
        }
        return storeChanged;
    }
}

