/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.tools.PhylogenyDecorator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class decorator {
    private static final String SEQUENCE_NAME_FIELD = "s";
    private static final String TAXONOMY_CODE_FIELD = "c";
    private static final String TAXONOMY_SCIENTIFIC_NAME_FIELD = "sn";
    private static final String DS_FILED = "d";
    private static final String SEQUENCE_ANNOTATION_DESC = "a";
    private static final String NODE_NAME_FIELD = "n";
    private static final String PICKY_OPTION = "p";
    private static final String FIELD_OPTION = "f";
    private static final String MOVE_DOMAIN_NUMBER_OPTION = "mdn";
    private static final String TREE_NAME_OPTION = "pn";
    private static final String TREE_ID_OPTION = "pi";
    private static final String TREE_DESC_OPTION = "pd";
    private static final String EXTRACT_BRACKETED_SCIENTIC_NAME_OPTION = "sn";
    private static final String PROCESS_NAME_INTELLIGENTLY_OPTION = "x";
    private static final String PROCESS_SIMILAR_TO_OPTION = "xs";
    private static final String CUT_NAME_AFTER_FIRST_SPACE_OPTION = "c";
    private static final String ALLOW_REMOVAL_OF_CHARS_OPTION = "r";
    private static final String ADVANCED_TABLE_OPTION = "table";
    private static final String KEY_COLUMN = "k";
    private static final String VALUE_COLUMN = "v";
    private static final String MAPPING_FILE_SEPARATOR_OPTION = "s";
    private static final String MAPPING_FILE_SEPARATOR_DEFAULT = ":";
    private static final boolean USE_FIRST_SEPARATOR_ONLY = true;
    private static final String PRG_NAME = "decorator";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2009.10.08";

    private static void argumentsError() {
        System.out.println();
        System.out.println("decorator -table | -f=<c> <phylogenies infile> <mapping table file> <phylogenies outfile>");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -table : table instead of one to one map (-f=<c>)");
        System.out.println(" -r=<n> : allow to remove up to n characters from the end of the names");
        System.out.println("          in phylogenies infile if not found (in map) otherwise");
        System.out.println(" -p     : for picky, fails if node name not found in mapping table, default is off");
        System.out.println(" -pn=<s>: name for the phylogeny");
        System.out.println(" -pi=<s>: identifier for the phylogeny (in the form provider:value)");
        System.out.println(" -pd=<s>: description for phylogenies");
        System.out.println();
        System.out.println();
        System.out.println("advanced options, only available if -table is not used:");
        System.out.println();
        System.out.println(" -f=<c> : field to be replaced: n : node name");
        System.out.println("                                a : sequence annotation description");
        System.out.println("                                d : domain structure");
        System.out.println("                                c : taxonomy code");
        System.out.println("                                sn: taxonomy scientific name");
        System.out.println("                                s : sequence name");
        System.out.println(" -k=<n> : key column in mapping table (0 based),");
        System.out.println("          names of the node to be decorated - default is 0");
        System.out.println(" -v=<n> : value column in mapping table (0 based),");
        System.out.println("          data which with to decorate - default is 1");
        System.out.println(" -sn    : to extract bracketed scientific names");
        System.out.println(" -s=<c> : column separator in mapping file, default is \":\"");
        System.out.println(" -x     : process name \"intelligently\" (only for -f=n)");
        System.out.println(" -xs    : process name \"intelligently\" and process information after \"similar to\" (only for -f=n)");
        System.out.println(" -c     : cut name after first space (only for -f=n)");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] args) {
        Phylogeny[] phylogenies;
        File phylogenies_outfile;
        block68: {
            boolean advanced_table;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
            if (args.length < 4 || args.length > 12) {
                decorator.argumentsError();
            }
            CommandLineArguments cla = null;
            try {
                cla = new CommandLineArguments(args);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            if (cla.getNumberOfNames() < 3 || cla.getNumberOfNames() > 4) {
                decorator.argumentsError();
            }
            File phylogenies_infile = cla.getFile(0);
            File mapping_infile = cla.getFile(1);
            phylogenies_outfile = cla.getFile(2);
            if (phylogenies_outfile.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "[" + phylogenies_outfile + "] already exists");
            }
            ArrayList<String> allowed_options = new ArrayList<String>();
            allowed_options.add(ADVANCED_TABLE_OPTION);
            allowed_options.add(PICKY_OPTION);
            allowed_options.add(FIELD_OPTION);
            allowed_options.add(PROCESS_NAME_INTELLIGENTLY_OPTION);
            allowed_options.add(PROCESS_SIMILAR_TO_OPTION);
            allowed_options.add("c");
            allowed_options.add(ALLOW_REMOVAL_OF_CHARS_OPTION);
            allowed_options.add(KEY_COLUMN);
            allowed_options.add(VALUE_COLUMN);
            allowed_options.add("s");
            allowed_options.add("sn");
            allowed_options.add(TREE_NAME_OPTION);
            allowed_options.add(TREE_ID_OPTION);
            allowed_options.add(TREE_DESC_OPTION);
            allowed_options.add(MOVE_DOMAIN_NUMBER_OPTION);
            String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
            if (dissallowed_options.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
            }
            if (!(advanced_table = cla.isOptionSet(ADVANCED_TABLE_OPTION))) {
                ArrayList<String> mandatory_options = new ArrayList<String>();
                mandatory_options.add(FIELD_OPTION);
                String missing_options = cla.validateMandatoryOptionsAsString(mandatory_options);
                if (missing_options.length() > 0) {
                    ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + missing_options);
                }
            }
            boolean picky = cla.isOptionSet(PICKY_OPTION);
            String separator = MAPPING_FILE_SEPARATOR_DEFAULT;
            if (cla.isOptionSet("s")) {
                if (advanced_table) {
                    decorator.argumentsError();
                }
                separator = cla.getOptionValue("s");
            }
            int key_column = 0;
            int value_column = 1;
            String field_str = "";
            PhylogenyDecorator.FIELD field = PhylogenyDecorator.FIELD.NODE_NAME;
            int numbers_of_chars_allowed_to_remove_if_not_found_in_map = -1;
            boolean cut_name_after_space = false;
            boolean process_name_intelligently = false;
            boolean process_similar_to = false;
            boolean extract_bracketed_scientific_name = false;
            boolean move_domain_numbers_at_end_to_middle = false;
            String tree_name = "";
            String tree_id = "";
            String tree_desc = "";
            try {
                if (cla.isOptionSet(TREE_NAME_OPTION)) {
                    tree_name = cla.getOptionValueAsCleanString(TREE_NAME_OPTION);
                }
                if (cla.isOptionSet(TREE_ID_OPTION)) {
                    tree_id = cla.getOptionValueAsCleanString(TREE_ID_OPTION);
                }
                if (cla.isOptionSet(TREE_DESC_OPTION)) {
                    tree_desc = cla.getOptionValueAsCleanString(TREE_DESC_OPTION);
                }
                if (cla.isOptionSet("sn")) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    extract_bracketed_scientific_name = true;
                }
                if (cla.isOptionSet(KEY_COLUMN)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    key_column = cla.getOptionValueAsInt(KEY_COLUMN);
                }
                if (cla.isOptionSet(VALUE_COLUMN)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    value_column = cla.getOptionValueAsInt(VALUE_COLUMN);
                }
                if (cla.isOptionSet("c")) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    cut_name_after_space = true;
                }
                if (cla.isOptionSet(PROCESS_NAME_INTELLIGENTLY_OPTION)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    process_name_intelligently = true;
                }
                if (cla.isOptionSet(PROCESS_SIMILAR_TO_OPTION)) {
                    if (advanced_table) {
                        decorator.argumentsError();
                    }
                    process_similar_to = true;
                }
                if (cla.isOptionSet(ALLOW_REMOVAL_OF_CHARS_OPTION)) {
                    numbers_of_chars_allowed_to_remove_if_not_found_in_map = cla.getOptionValueAsInt(ALLOW_REMOVAL_OF_CHARS_OPTION);
                }
                if (cla.isOptionSet(MOVE_DOMAIN_NUMBER_OPTION)) {
                    move_domain_numbers_at_end_to_middle = true;
                }
                if (cla.isOptionSet(FIELD_OPTION)) {
                    field_str = cla.getOptionValue(FIELD_OPTION);
                    if (field_str.equals(NODE_NAME_FIELD)) {
                        field = PhylogenyDecorator.FIELD.NODE_NAME;
                    } else if (field_str.equals(SEQUENCE_ANNOTATION_DESC)) {
                        field = PhylogenyDecorator.FIELD.SEQUENCE_ANNOTATION_DESC;
                    } else if (field_str.equals(DS_FILED)) {
                        field = PhylogenyDecorator.FIELD.DOMAIN_STRUCTURE;
                        extract_bracketed_scientific_name = false;
                    } else if (field_str.equals("c")) {
                        field = PhylogenyDecorator.FIELD.TAXONOMY_CODE;
                    } else if (field_str.equals("s")) {
                        field = PhylogenyDecorator.FIELD.SEQUENCE_NAME;
                    } else if (field_str.equals("sn")) {
                        field = PhylogenyDecorator.FIELD.TAXONOMY_SCIENTIFIC_NAME;
                        extract_bracketed_scientific_name = false;
                    } else {
                        ForesterUtil.fatalError(PRG_NAME, "unknown value for \"f\" option: \"" + field_str + "\"");
                    }
                }
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
            }
            if (field != PhylogenyDecorator.FIELD.NODE_NAME && (cut_name_after_space || process_name_intelligently)) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -x or -c option without -f=n");
            }
            if (field != PhylogenyDecorator.FIELD.NODE_NAME && process_similar_to) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs option without -f=n");
            }
            if (cut_name_after_space && process_name_intelligently) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -x and -c option together");
            }
            if (process_similar_to && process_name_intelligently) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs and -x option together");
            }
            if (process_similar_to && cut_name_after_space) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs and -c option together");
            }
            phylogenies = null;
            try {
                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(phylogenies_infile, true);
                phylogenies = factory.create(phylogenies_infile, pp);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + phylogenies_infile + "] [" + e.getMessage() + "]");
            }
            Map<String, String> map = null;
            if (!advanced_table) {
                BasicTable<String> mapping_table = null;
                try {
                    mapping_table = BasicTableParser.parse(mapping_infile, separator, true);
                }
                catch (Exception e) {
                    ForesterUtil.fatalError(PRG_NAME, "failed to read [" + mapping_infile + "] [" + e.getMessage() + "]");
                }
                if (key_column < 0 || key_column >= mapping_table.getNumberOfColumns()) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal value for key column");
                }
                if (value_column < 0 || value_column >= mapping_table.getNumberOfColumns()) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal value for value column");
                }
                map = mapping_table.getColumnsAsMap(key_column, value_column);
            }
            if (!(ForesterUtil.isEmpty(tree_name) && ForesterUtil.isEmpty(tree_id) && ForesterUtil.isEmpty(tree_desc))) {
                if (!(phylogenies.length <= 1 || ForesterUtil.isEmpty(tree_name) && ForesterUtil.isEmpty(tree_id))) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to set same name or id on more than one phylogeny");
                }
                if (!ForesterUtil.isEmpty(tree_name)) {
                    phylogenies[0].setName(tree_name);
                }
                if (!ForesterUtil.isEmpty(tree_id)) {
                    String[] s_ary = tree_id.split(MAPPING_FILE_SEPARATOR_DEFAULT);
                    phylogenies[0].setIdentifier(new Identifier(s_ary[1], s_ary[0]));
                }
                if (!ForesterUtil.isEmpty(tree_desc)) {
                    int i = 0;
                    while (i < phylogenies.length) {
                        phylogenies[i].setDescription(tree_desc);
                        ++i;
                    }
                }
            }
            try {
                if (advanced_table) {
                    Map<String, Map<String, String>> table = null;
                    try {
                        table = PhylogenyDecorator.parseMappingTable(mapping_infile);
                    }
                    catch (IOException e) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + mapping_infile + "\" [" + e.getMessage() + "]");
                    }
                    PhylogenyDecorator.decorate(phylogenies, table, picky, numbers_of_chars_allowed_to_remove_if_not_found_in_map);
                    break block68;
                }
                PhylogenyDecorator.decorate(phylogenies, map, field, extract_bracketed_scientific_name, picky, cut_name_after_space, process_name_intelligently, process_similar_to, numbers_of_chars_allowed_to_remove_if_not_found_in_map, move_domain_numbers_at_end_to_middle);
            }
            catch (NullPointerException e) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, e);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to map [" + e + "]");
            }
        }
        try {
            PhylogenyWriter w = new PhylogenyWriter();
            w.toPhyloXML(phylogenies, 0, phylogenies_outfile, ForesterUtil.getLineSeparator());
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + e.getMessage() + "]");
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "wrote: " + phylogenies_outfile);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }
}

