/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.go.etc.MetaOntologizer;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class meta_ontologizer {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String P_OPTION = "p";
    private static final String PRG_NAME = "meta_ontologizer";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2009.04.29";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";
    private static final String RESULT_FILE_PREFIX = "table";

    public static void main(String[] args) {
        String dissallowed_options;
        String missing;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            meta_ontologizer.printHelp();
            System.exit(0);
        }
        if (args.length < 4) {
            System.out.println();
            System.out.println("[meta_ontologizer] incorrect number of arguments");
            System.out.println();
            meta_ontologizer.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(P_OPTION);
        ArrayList<String> mandatory_options = new ArrayList<String>();
        mandatory_options.add(P_OPTION);
        if (cla.getNumberOfNames() != 5 && cla.getNumberOfNames() != 6) {
            System.out.println();
            System.out.println("[meta_ontologizer] incorrect number of arguments");
            System.out.println();
            meta_ontologizer.printHelp();
            System.exit(-1);
        }
        if ((missing = cla.validateMandatoryOptionsAsString(mandatory_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + missing);
        }
        if ((dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        File obo_file = cla.getFile(0);
        File pfam2go_file = cla.getFile(1);
        File ontologizer_outdir = cla.getFile(2);
        File domain_gain_loss_file = null;
        String outfile_base = null;
        String comment = null;
        if (cla.getNumberOfNames() == 6) {
            domain_gain_loss_file = cla.getFile(3);
            outfile_base = cla.getName(4);
            comment = cla.getName(5);
        } else {
            outfile_base = cla.getName(3);
            comment = cla.getName(4);
        }
        double p_adjusted_upper_limit = -1.0;
        try {
            p_adjusted_upper_limit = cla.getOptionValueAsDouble(P_OPTION);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        try {
            PfamToGoParser parser = new PfamToGoParser(pfam2go_file);
            List<PfamToGoMapping> pfam_to_go_mappings = parser.parse();
            ForesterUtil.programMessage(PRG_NAME, "parsed " + pfam_to_go_mappings.size() + " Pfam to GO mappings");
            MetaOntologizer.reformat(ontologizer_outdir, RESULT_FILE_PREFIX, domain_gain_loss_file, outfile_base, obo_file, p_adjusted_upper_limit, comment, pfam_to_go_mappings);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            e.printStackTrace();
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("meta_ontologizer -p=<adj P value limit> <obo file> <pfam to go file> <ontologizer outdir> [domain gain loss file] <base for meta ontologizer outfile> <comment>");
        System.out.println();
    }
}

