/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.surfacing.DomainId;

public class pfam2go_extractor {
    private static final String PRG_NAME = "pfam2go_extractor";

    public static void main(String[] args) {
        if (args.length < 3) {
            pfam2go_extractor.printHelp();
        }
        PfamToGoParser p = new PfamToGoParser(new File(args[0]));
        List<PfamToGoMapping> pfam2go = null;
        try {
            pfam2go = p.parse();
        }
        catch (IOException e) {
            pfam2go_extractor.printHelp();
            e.printStackTrace();
        }
        OBOparser parser = new OBOparser(new File(args[1]), OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> all_go_terms = null;
        try {
            all_go_terms = parser.parse();
        }
        catch (IOException e) {
            pfam2go_extractor.printHelp();
            e.printStackTrace();
        }
        Map<GoId, GoTerm> goid_to_term_map = GoUtils.createGoIdToGoTermMap(all_go_terms);
        System.out.println("# pfam2go : " + args[0]);
        System.out.println("# OBO file: " + args[1]);
        GoId[] queries = new GoId[args.length - 2];
        int i = 2;
        while (i < args.length) {
            queries[i - 2] = new GoId(args[i]);
            System.out.println("# " + (i - 2) + ": " + queries[i - 2].getId() + " = " + goid_to_term_map.get(queries[i - 2]).getName() + " (" + goid_to_term_map.get(queries[i - 2]).getDefinition() + ")");
            ++i;
        }
        TreeSet<String> pfams = new TreeSet<String>();
        for (PfamToGoMapping pfam_to_go_mapping : pfam2go) {
            DomainId domain_id = pfam_to_go_mapping.getKey();
            GoId go_id = pfam_to_go_mapping.getValue();
            SortedSet<GoId> supers = GoUtils.getAllSuperGoIds(go_id, goid_to_term_map);
            supers.add(go_id);
            int i2 = 0;
            while (i2 < queries.length) {
                if (supers.contains(queries[i2])) {
                    pfams.add(domain_id.toString());
                }
                ++i2;
            }
        }
        for (String pfam : pfams) {
            System.out.println(pfam);
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("pfam2go_extractor <pfam2go mapping file> <file with all GO terms, in 'obo' format> <GO id> [more GO ids]");
        System.out.println();
    }
}

