/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class phyloxml_converter {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String FIELD_OPTION = "f";
    private static final String FIELD_CLADE_NAME = "nn";
    private static final String FIELD_TAXONOMY_CODE = "tc";
    private static final String FIELD_TAXONOMY_SCI_NAME = "sn";
    private static final String FIELD_TAXONOMY_COMM_NAME = "cn";
    private static final String FIELD_SEQUENCE_GENE_NAME = "gn";
    private static final String FIELD_SEQUENCE_SYMBOL = "sy";
    private static final String FIELD_DUMMY = "dummy";
    private static final String INTERNAL_NAMES_ARE_BOOT_SUPPPORT = "i";
    private static final String MIDPOINT_REROOT = "m";
    private static final String EXTRACT_TAXONOMY = "xt";
    private static final String EXTRACT_TAXONOMY_PF = "xp";
    private static final String ORDER_SUBTREES = "o";
    private static final String NO_TREE_LEVEL_INDENDATION = "ni";
    private static final String REPLACE_UNDER_SCORES = "ru";
    private static final String ALLOW_QUOTATION_MARKS_AND_SPACES = "qs";
    private static final String PRG_NAME = "phyloxml_converter";
    private static final String PRG_VERSION = "1.20";
    private static final String PRG_DATE = "2009.10.13";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";
    private static final boolean SPECIAL = false;

    public static void main(String[] args) {
        Phylogeny phy;
        int n;
        Phylogeny[] phylogenyArray;
        String dissallowed_options;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            phyloxml_converter.printHelp();
            System.exit(0);
        }
        if (args.length < 3) {
            System.out.println();
            System.out.println("[phyloxml_converter] incorrect number of arguments");
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(NO_TREE_LEVEL_INDENDATION);
        allowed_options.add(FIELD_OPTION);
        allowed_options.add(MIDPOINT_REROOT);
        allowed_options.add(ORDER_SUBTREES);
        allowed_options.add(INTERNAL_NAMES_ARE_BOOT_SUPPPORT);
        allowed_options.add(REPLACE_UNDER_SCORES);
        allowed_options.add(EXTRACT_TAXONOMY);
        allowed_options.add(EXTRACT_TAXONOMY_PF);
        allowed_options.add(ALLOW_QUOTATION_MARKS_AND_SPACES);
        if (cla.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[phyloxml_converter] incorrect number of arguments");
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        if ((dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        ArrayList<String> mandatory_options = new ArrayList<String>();
        mandatory_options.add(FIELD_OPTION);
        String missing_options = cla.validateMandatoryOptionsAsString(mandatory_options);
        if (missing_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + missing_options);
        }
        if (!cla.isOptionValueSet(FIELD_OPTION)) {
            System.out.println();
            phyloxml_converter.printHelp();
            System.exit(-1);
        }
        String field_option_value = cla.getOptionValue(FIELD_OPTION);
        ForesterUtil.PhylogenyNodeField field = null;
        if (field_option_value.equals(FIELD_CLADE_NAME)) {
            field = ForesterUtil.PhylogenyNodeField.CLADE_NAME;
        } else if (field_option_value.equals(FIELD_TAXONOMY_CODE)) {
            field = ForesterUtil.PhylogenyNodeField.TAXONOMY_CODE;
        } else if (field_option_value.equals(FIELD_TAXONOMY_SCI_NAME)) {
            field = ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME;
        } else if (field_option_value.equals(FIELD_TAXONOMY_COMM_NAME)) {
            field = ForesterUtil.PhylogenyNodeField.TAXONOMY_COMMON_NAME;
        } else if (field_option_value.equals(FIELD_SEQUENCE_GENE_NAME)) {
            field = ForesterUtil.PhylogenyNodeField.SEQUENCE_NAME;
        } else if (field_option_value.equals(FIELD_SEQUENCE_SYMBOL)) {
            field = ForesterUtil.PhylogenyNodeField.SEQUENCE_SYMBOL;
        } else if (!field_option_value.equals(FIELD_DUMMY)) {
            ForesterUtil.fatalError(PRG_NAME, "unknown value for -\"f\" option: \"" + field_option_value + "\"");
        }
        boolean int_values_are_boots = false;
        if (cla.isOptionSet(INTERNAL_NAMES_ARE_BOOT_SUPPPORT)) {
            int_values_are_boots = true;
        }
        boolean midpoint_reroot = false;
        if (cla.isOptionSet(MIDPOINT_REROOT)) {
            midpoint_reroot = true;
        }
        boolean order_subtrees = false;
        if (cla.isOptionSet(ORDER_SUBTREES)) {
            order_subtrees = true;
        }
        boolean replace_underscores = false;
        if (cla.isOptionSet(REPLACE_UNDER_SCORES)) {
            replace_underscores = true;
        }
        boolean allow_quotes = false;
        if (cla.isOptionSet(ALLOW_QUOTATION_MARKS_AND_SPACES)) {
            allow_quotes = true;
        }
        boolean no_indendation = false;
        if (cla.isOptionSet(NO_TREE_LEVEL_INDENDATION)) {
            no_indendation = true;
        }
        boolean extr_taxonomy = false;
        if (cla.isOptionSet(EXTRACT_TAXONOMY)) {
            extr_taxonomy = true;
        }
        boolean extr_taxonomy_pf_only = false;
        if (cla.isOptionSet(EXTRACT_TAXONOMY_PF)) {
            extr_taxonomy_pf_only = true;
        }
        File infile = cla.getFile(0);
        File outfile = cla.getFile(1);
        if (outfile.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + outfile + "] already exists");
        }
        if (!infile.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + infile + "] does not exist");
        }
        Phylogeny[] phys = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser parser = ForesterUtil.createParserDependingOnFileType(infile, true);
            if (parser instanceof NHXParser) {
                if (field != ForesterUtil.PhylogenyNodeField.TAXONOMY_CODE && field != ForesterUtil.PhylogenyNodeField.TAXONOMY_COMMON_NAME && field != ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME) {
                    if (extr_taxonomy_pf_only) {
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                        replace_underscores = false;
                    } else if (extr_taxonomy) {
                        ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.YES);
                        replace_underscores = false;
                    }
                } else {
                    ((NHXParser)parser).setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                }
                ((NHXParser)parser).setReplaceUnderscores(replace_underscores);
                ((NHXParser)parser).setIgnoreQuotes(!allow_quotes);
            } else if (parser instanceof NexusPhylogeniesParser) {
                ((NexusPhylogeniesParser)parser).setReplaceUnderscores(replace_underscores);
                ((NexusPhylogeniesParser)parser).setIgnoreQuotes(!allow_quotes);
            }
            phys = factory.create(infile, parser);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read phylogeny from [" + infile + "]: " + e.getMessage());
        }
        if (int_values_are_boots) {
            phylogenyArray = phys;
            n = phys.length;
            int n2 = 0;
            while (n2 < n) {
                phy = phylogenyArray[n2];
                ForesterUtil.transferInternalNamesToBootstrapSupport(phy);
                ++n2;
            }
        }
        if (field != null) {
            phylogenyArray = phys;
            n = phys.length;
            int n3 = 0;
            while (n3 < n) {
                phy = phylogenyArray[n3];
                ForesterUtil.transferNodeNameToField(phy, field);
                ++n3;
            }
        }
        if (midpoint_reroot) {
            try {
                phylogenyArray = phys;
                n = phys.length;
                int n4 = 0;
                while (n4 < n) {
                    phy = phylogenyArray[n4];
                    PhylogenyMethods.midpointRoot(phy);
                    ++n4;
                }
            }
            catch (Exception e) {
                System.out.println("");
                ForesterUtil.printWarningMessage(PRG_NAME, "midpoint rerooting failed: " + e.getLocalizedMessage());
            }
        }
        if (order_subtrees) {
            phylogenyArray = phys;
            n = phys.length;
            int n5 = 0;
            while (n5 < n) {
                phy = phylogenyArray[n5];
                phy.orderAppearance(true);
                ++n5;
            }
        }
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            if (no_indendation) {
                writer.setIndentPhyloxml(false);
            }
            writer.toPhyloXML(phys, 0, outfile, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + outfile + "]: " + e.getMessage());
        }
        System.out.println("[phyloxml_converter] wrote: [" + outfile + "]");
        System.out.println("[phyloxml_converter] OK");
        System.out.println();
    }

    private static void performSpecialProcessing(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            String name = node.getNodeName();
            ForesterUtil.isEmpty(name);
        }
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("phyloxml_converter -f=<field option> [options] <infile in New Hamphshire, NHX, Nexus, ToL XML, or phyloXML format> <outfile>");
        System.out.println();
        System.out.println(" field options: ");
        System.out.println();
        System.out.println("   nn: transfer name to node/clade name");
        System.out.println("   tc: transfer name to taxonomy code");
        System.out.println("   sn: transfer name to taxonomy scientific name");
        System.out.println("   cn: transfer name to taxonomy common name");
        System.out.println("   gn: transfer name to sequence name");
        System.out.println("   sy: transfer name to sequence symbol");
        System.out.println();
        System.out.println(" options: ");
        System.out.println(" -i : internal names in NH or NHX tree are bootstrap support values");
        System.out.println(" -ru: replace all underscores with spaces");
        System.out.println(" -qs: allow quotation marks and spaces (default: ignore)");
        System.out.println(" -m : midpoint reroot");
        System.out.println(" -o : order subtrees");
        System.out.println(" -xt: extract taxonomy to taxonomy code from \"seqname_TAXON\"-style names (cannot be used with the following field options: tc, cn, sn)");
        System.out.println(" -xp: extract taxonomy to taxonomy code from Pfam (\"seqname_TAXON/x-y\") style names only (cannot be used with the following field options: tc, cn, sn)");
        System.out.println(" -ni: no tree level indendation in phyloXML output");
        System.out.println();
    }
}

