/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.SDIR;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class sdi_r {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String MIN_MAPPING_COST_OPTION = "ml";
    private static final String MIN_DUPS_OPTION = "md";
    private static final String MIN_HEIGHT_OPTION = "mh";
    private static final String PRG_NAME = "sdi_r";
    private static final String PRG_VERSION = "1.11";
    private static final String PRG_DATE = "2009.06.19";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org";
    private static final int TREES_TO_RETURN = 5;

    public static void main(String[] args) {
        PhyloXmlParser pp;
        File outfile;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length == 0) {
            sdi_r.printHelp();
            System.exit(0);
        }
        if (args.length < 3 || cla.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[sdi_r] incorrect number of arguments");
            System.out.println();
            sdi_r.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(MIN_MAPPING_COST_OPTION);
        allowed_options.add(MIN_DUPS_OPTION);
        allowed_options.add(MIN_HEIGHT_OPTION);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        if ((outfile = new File("sdir_outfile.xml")).exists()) {
            ForesterUtil.fatalError(PRG_NAME, "outfile \"" + outfile + "\" already exists");
        }
        File gene_tree_file = cla.getFile(0);
        File species_tree_file = cla.getFile(1);
        boolean minimize_cost = false;
        if (cla.isOptionSet(MIN_MAPPING_COST_OPTION)) {
            minimize_cost = true;
        }
        boolean minimize_sum_of_dup = false;
        if (cla.isOptionSet(MIN_DUPS_OPTION)) {
            minimize_sum_of_dup = true;
        }
        boolean minimize_height = false;
        if (cla.isOptionSet(MIN_HEIGHT_OPTION)) {
            minimize_height = true;
        }
        int r = 0;
        Phylogeny[] gene_trees = null;
        Phylogeny species_tree = null;
        if (minimize_cost && minimize_sum_of_dup) {
            minimize_sum_of_dup = false;
        }
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        try {
            pp = new PhyloXmlParser();
            species_tree = factory.create(species_tree_file, pp)[0];
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species tree [" + species_tree_file + "]: " + e.getLocalizedMessage());
        }
        if (!species_tree.isRooted()) {
            ForesterUtil.fatalError(PRG_NAME, "species tree [" + species_tree_file + "] is not rooted");
        }
        try {
            pp = new PhyloXmlParser();
            gene_trees = factory.create(gene_tree_file, pp);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read gene trees [" + gene_tree_file + "]: " + e.getLocalizedMessage());
        }
        int gene_tree_counter = 0;
        ArrayList<Phylogeny> all_result_trees = new ArrayList<Phylogeny>();
        Phylogeny[] phylogenyArray = gene_trees;
        int n = gene_trees.length;
        int n2 = 0;
        while (n2 < n) {
            Phylogeny gene_tree = phylogenyArray[n2];
            r = PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gene_tree);
            ForesterUtil.programMessage(PRG_NAME, "Removed " + r + " external nodes from gene tree");
            SDIR sdiunrooted = new SDIR();
            long start_time = new Date().getTime();
            Phylogeny[] result_trees = null;
            try {
                result_trees = sdiunrooted.infer(gene_tree, species_tree, minimize_cost, minimize_sum_of_dup, minimize_height, true, 5);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
            long time_req = new Date().getTime() - start_time;
            if (minimize_cost) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing mapping cost L");
                if (minimize_height) {
                    ForesterUtil.programMessage(PRG_NAME, "Selected tree(s) with minimal height out of resulting trees");
                }
                ForesterUtil.programMessage(PRG_NAME, "Number differently rooted trees minimizing criterion  : " + sdiunrooted.getCount());
                ForesterUtil.programMessage(PRG_NAME, "Minimal cost                                          : " + sdiunrooted.getMinimalMappingCost());
                ForesterUtil.programMessage(PRG_NAME, "Minimal duplications                                  : " + sdiunrooted.getMinimalDuplications());
                if (minimize_height) {
                    ForesterUtil.programMessage(PRG_NAME, "Phylogeny height                                      : " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalTreeHeight()));
                    ForesterUtil.programMessage(PRG_NAME, "Difference in subtree heights                         : " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
                }
            } else if (minimize_sum_of_dup) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing sum of duplications");
                if (minimize_height) {
                    ForesterUtil.programMessage(PRG_NAME, "Selected tree(s) with minimal height out of resulting trees");
                }
                ForesterUtil.programMessage(PRG_NAME, "Number differently rooted trees minimizing criterion        : " + sdiunrooted.getCount());
                ForesterUtil.programMessage(PRG_NAME, "Minimal duplications                                        : " + sdiunrooted.getMinimalDuplications());
                if (minimize_height) {
                    ForesterUtil.programMessage(PRG_NAME, "Phylogeny height                                            : " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalTreeHeight()));
                    ForesterUtil.programMessage(PRG_NAME, "Difference in subtree heights                               : " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
                }
            } else if (minimize_height) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing tree height (midpoint rooting).");
                ForesterUtil.programMessage(PRG_NAME, "Minimal tree height                  : " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalTreeHeight()));
                ForesterUtil.programMessage(PRG_NAME, "Minimal difference in subtree heights: " + ForesterUtil.FORMATTER_06.format(sdiunrooted.getMinimalDiffInSubTreeHeights()));
                ForesterUtil.programMessage(PRG_NAME, "Duplications in midpoint rooted tree : " + sdiunrooted.getMinimalDuplications());
            } else {
                ForesterUtil.programMessage(PRG_NAME, "No (re) rooting was performed.");
                ForesterUtil.programMessage(PRG_NAME, "Duplications in tree: " + sdiunrooted.getMinimalDuplications());
            }
            ForesterUtil.programMessage(PRG_NAME, "Time requirement (minus I/O)                          : " + time_req + "ms");
            int i = 0;
            while (i < result_trees.length) {
                String name = result_trees[i].getName();
                if (ForesterUtil.isEmpty(name)) {
                    result_trees[i].setName("SDIR result [gene tree + " + gene_tree_counter + "]" + " " + i);
                } else {
                    result_trees[i].setName(String.valueOf(name) + " SDIR result [gene tree + " + gene_tree_counter + "]" + " " + i);
                }
                all_result_trees.add(result_trees[i]);
                ++i;
            }
            ++gene_tree_counter;
            ++n2;
        }
        try {
            PhylogenyWriter w = new PhylogenyWriter();
            w.toPhyloXML(outfile, all_result_trees, 0, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failure to write output to [" + outfile + "]: " + e.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote: " + outfile);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }

    private static void printHelp() {
        System.out.println("Usage: sdi_r <options> <gene tree(s) in phyloXML format> <species tree in phyloXML format>\"");
        System.out.println("\nOptions:");
        System.out.println(" -ml to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -md to root by minimizing the sum of duplications");
        System.out.println(" -mh to root by minimizing tree height (can be used together with -ml or -md)");
        System.out.println("");
    }
}

