/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.Shin;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class shin {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String DEFAULT_OUTFILE = "out";
    private static final String PRG_NAME = "shin";
    private static final String PRG_VERSION = "0.001 alpha";
    private static final String PRG_DATE = "2009.10.14";

    public static void main(String[] args) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            shin.print_help();
            System.exit(0);
        } else if (args.length != 3) {
            System.out.println();
            System.out.println("wrong number of arguments");
            System.out.println();
            shin.print_help();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        File gene_trees_dir = null;
        File species_trees_file = null;
        File out_dir = null;
        Phylogeny[] species_trees = null;
        try {
            gene_trees_dir = cla.getFile(0);
            species_trees_file = cla.getFile(1);
            out_dir = cla.getFile(2);
        }
        catch (IllegalArgumentException e) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
        }
        if (ForesterUtil.isReadableFile(species_trees_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(species_trees_file));
        }
        if (!gene_trees_dir.isDirectory() || !gene_trees_dir.canRead()) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read gene trees from [" + gene_trees_dir + "]");
        }
        if (!out_dir.exists()) {
            boolean success = false;
            try {
                success = out_dir.mkdir();
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create [" + out_dir + "] [" + e.getMessage() + "]");
            }
            if (!success) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create [" + out_dir + "]");
            }
        }
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            species_trees = factory.create(species_trees_file, new PhyloXmlParser());
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species trees from [" + species_trees_file + "] [" + e.getMessage() + "]");
        }
        if (species_trees == null || species_trees.length < 1) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species trees from [" + species_trees_file + "]");
        }
        ForesterUtil.programMessage(PRG_NAME, "read in " + species_trees.length + " species trees from [" + species_trees_file + "]");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && !name.startsWith("00_") && name.endsWith(".xml");
            }
        };
        Object[] gene_tree_names = gene_trees_dir.list(filter);
        Arrays.sort(gene_tree_names);
        ArrayList<File> gene_tree_files = new ArrayList<File>();
        Object[] objectArray = gene_tree_names;
        int n = gene_tree_names.length;
        int n2 = 0;
        while (n2 < n) {
            Object gene_tree_name = objectArray[n2];
            File gene_tree_file = new File(gene_trees_dir + ForesterUtil.FILE_SEPARATOR + (String)gene_tree_name);
            if (!gene_tree_file.isDirectory()) {
                gene_tree_files.add(gene_tree_file);
            }
            ++n2;
        }
        ForesterUtil.programMessage(PRG_NAME, "going to analyze " + gene_tree_files.size() + " gene trees from [" + gene_trees_dir + "]");
        Shin shin2 = new Shin();
        try {
            shin2.method1(gene_tree_files, species_trees, out_dir);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            e.printStackTrace();
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
    }

    private static void print_help() {
        System.out.println("Usage: shin [-options] <gene trees dir> <species tree file name> <outdir>");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
    }
}

