/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.nexus.NexusCharactersParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nexus.PaupLogParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class surf_paup {
    private static final String PRG_VERSION = "0.90";
    private static final String PRG_DATE = "2008.03.28";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/applications/surfacing";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "surf_paup";

    public static void main(String[] args) {
        Phylogeny phylogeny;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(HELP_OPTION_1);
        allowed_options.add(HELP_OPTION_2);
        if (args.length < 2) {
            surf_paup.printHelp();
            System.exit(-1);
        }
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            surf_paup.printHelp();
            System.exit(0);
        }
        if (cla.getNumberOfNames() != 3) {
            surf_paup.printHelp();
            System.exit(-1);
        }
        File surfacing_nexus_outfile = cla.getFile(0);
        File paup_log_file = cla.getFile(1);
        String outfile_name = cla.getFile(2).toString();
        NexusCharactersParser nex_char_parser = new NexusCharactersParser();
        try {
            nex_char_parser.setSource(surfacing_nexus_outfile);
            nex_char_parser.parse();
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "problem with parsing character labels from  [" + surfacing_nexus_outfile + "]: " + e.getMessage());
            e.printStackTrace();
        }
        String[] labels = nex_char_parser.getCharStateLabels();
        ForesterUtil.programMessage(PRG_NAME, "read in " + labels.length + " character labels");
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        NexusPhylogeniesParser phylogeny_parser = new NexusPhylogeniesParser();
        Phylogeny[] phylogenies = null;
        try {
            phylogenies = factory.create(surfacing_nexus_outfile, phylogeny_parser);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "problem with parsing phylogeny [" + surfacing_nexus_outfile + "]: " + e.getMessage());
            e.printStackTrace();
        }
        if (phylogenies.length != 1) {
            ForesterUtil.fatalError(PRG_NAME, "failed to parse one phylogeny from [" + surfacing_nexus_outfile + "], got " + phylogenies.length + " instead");
        }
        if (!(phylogeny = phylogenies[0]).isRooted()) {
            ForesterUtil.fatalError(PRG_NAME, "phylogeny from [" + surfacing_nexus_outfile + "] is not rooted");
        }
        ForesterUtil.postOrderRelabelInternalNodes(phylogeny, phylogeny.getNumberOfExternalNodes() + 1);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix = null;
        PaupLogParser paup_log_parser = new PaupLogParser();
        try {
            paup_log_parser.setSource(paup_log_file);
            matrix = paup_log_parser.parse();
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "failed to parse matrix from  [" + paup_log_file + "]: " + e.getMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "read in character state matrix of size " + matrix.getNumberOfIdentifiers() + "x" + matrix.getNumberOfCharacters());
        DomainParsimonyCalculator domain_parsimony = DomainParsimonyCalculator.createInstance(phylogeny);
        domain_parsimony.executeOnGivenBinaryStatesMatrix(matrix, labels);
        String sep = String.valueOf(ForesterUtil.LINE_SEPARATOR) + "###################" + ForesterUtil.LINE_SEPARATOR;
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossMatrix(), String.valueOf(outfile_name) + "_paup_gl", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossCountsMatrix(), String.valueOf(outfile_name) + "_paup_glc", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_paup_gains", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_paup_losses", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_paup_present", sep, ForesterUtil.LINE_SEPARATOR, null);
        String date_time = ForesterUtil.getCurrentDateTime();
        SurfacingUtil.preparePhylogeny(phylogeny, domain_parsimony, date_time, "parsimony (paup)", "paup_" + outfile_name, "");
        SurfacingUtil.writePhylogenyToFile(phylogeny, String.valueOf(outfile_name) + "_paup.xml");
        ForesterUtil.programMessage(PRG_NAME, "OK");
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java  -cp forester.jar org.forester.applications.surf_paup <surfacing nexus outfile with character labels and tree> <paup log file with reconstructed states matrix> <outfile name base>");
        System.out.println();
    }
}

