/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.Util;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public final class Archaeopteryx {
    private static final boolean TEST = false;

    public static MainFrame createApplication(Phylogeny phylogeny) {
        Phylogeny[] phylogenies = new Phylogeny[]{phylogeny};
        return Archaeopteryx.createApplication(phylogenies, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenies) {
        return Archaeopteryx.createApplication(phylogenies, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenies, String config_file_name, String title) {
        return MainFrameApplication.createInstance(phylogenies, config_file_name, title);
    }

    public static void main(String[] args) {
        Phylogeny[] phylogenies = null;
        String config_filename = null;
        Configuration conf = null;
        File f = null;
        try {
            int filename_index = 0;
            if (args.length == 0) {
                conf = new Configuration(null, false, false);
            } else if (args.length > 0) {
                if (args[0].startsWith("-c")) {
                    config_filename = args[1];
                    filename_index += 2;
                }
                conf = new Configuration(config_filename, false, false);
                if (args.length > filename_index) {
                    f = new File(args[filename_index]);
                    String err = ForesterUtil.isReadableFile(f);
                    if (!ForesterUtil.isEmpty(err)) {
                        ForesterUtil.fatalError("Archaeopteryx", err);
                    }
                    boolean nhx_or_nexus = false;
                    PhylogenyParser p = ForesterUtil.createParserDependingOnFileType(f, conf.isValidatePhyloXmlAgainstSchema());
                    if (p instanceof NHXParser) {
                        nhx_or_nexus = true;
                        NHXParser nhx = (NHXParser)p;
                        nhx.setReplaceUnderscores(conf.isReplaceUnderscoresInNhParsing());
                        nhx.setIgnoreQuotes(conf.isNhParsingIgnoreQuotes());
                        NHXParser.TAXONOMY_EXTRACTION te = NHXParser.TAXONOMY_EXTRACTION.NO;
                        if (conf.isExtractPfamTaxonomyCodesInNhParsing()) {
                            te = NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY;
                        }
                        nhx.setTaxonomyExtraction(te);
                    } else if (p instanceof NexusPhylogeniesParser) {
                        nhx_or_nexus = true;
                        NexusPhylogeniesParser nex = (NexusPhylogeniesParser)p;
                        nex.setReplaceUnderscores(conf.isReplaceUnderscoresInNhParsing());
                        nex.setIgnoreQuotes(conf.isNhParsingIgnoreQuotes());
                    } else if (p instanceof PhyloXmlParser) {
                        MainFrameApplication.warnIfNotPhyloXmlValidation(conf);
                    }
                    phylogenies = Util.readPhylogenies(p, f);
                    if (nhx_or_nexus && conf.isInternalNumberAreConfidenceForNhParsing()) {
                        Phylogeny[] phylogenyArray = phylogenies;
                        int n = phylogenies.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Phylogeny phy = phylogenyArray[n2];
                            ForesterUtil.transferInternalNodeNamesToConfidence(phy);
                            ++n2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ForesterUtil.fatalError("Archaeopteryx", "failed to start: " + e.getLocalizedMessage());
        }
        String title = "";
        if (f != null) {
            title = f.getName();
        }
        try {
            String s = "";
            MainFrameApplication.createInstance(phylogenies, conf, title);
        }
        catch (Exception ex) {
            Util.unexpectedException(ex);
        }
        catch (Error err) {
            Util.unexpectedError(err);
        }
    }
}

