/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.UIManager;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrameApplet;
import org.forester.archaeopteryx.Util;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public class ArchaeopteryxA
extends JApplet {
    private static final long serialVersionUID = 2314899014580484146L;
    private static final Color background_color = new Color(0, 0, 0);
    private static final Color font_color = new Color(0, 255, 0);
    private static final Color ex_background_color = new Color(0, 0, 0);
    private static final Color ex_font_color = new Color(255, 0, 0);
    private static final Font font = new Font(Configuration.getDefaultFontFamilyName(), 1, 9);
    private MainFrameApplet _mainframe_applet;
    private String _url_string = "";
    private String _message_1 = "";
    private String _message_2 = "";
    public static final String NAME = "ArchaeopteryxA";

    @Override
    public void destroy() {
        Util.printAppletMessage(NAME, "going to be destroyed");
        if (this.getMainFrameApplet() != null) {
            this.getMainFrameApplet().close();
        }
    }

    private MainFrameApplet getMainFrameApplet() {
        return this._mainframe_applet;
    }

    private String getMessage1() {
        return this._message_1;
    }

    private String getMessage2() {
        return this._message_2;
    }

    public String getUrlString() {
        return this._url_string;
    }

    @Override
    public void init() {
        boolean has_exception = false;
        this.setName(NAME);
        this.setUrlString(this.getParameter("url_of_tree_to_load"));
        Util.printAppletMessage(NAME, "URL of phylogenies to load: \"" + this.getUrlString() + "\"");
        this.setBackground(background_color);
        this.setForeground(font_color);
        this.setFont(font);
        this.repaint();
        String s = null;
        try {
            s = System.getProperty("java.version");
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage(NAME, "minor error: " + e.getLocalizedMessage());
        }
        if (s != null && s.length() > 0) {
            this.setMessage2("[Your Java version: " + s + "]");
            this.repaint();
        }
        String config_filename = this.getParameter("config_file");
        Util.printAppletMessage(NAME, "URL for configuration file is: " + config_filename);
        Configuration configuration = new Configuration(config_filename, true, true);
        try {
            if (configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            this.setVisible(false);
            this._mainframe_applet = new MainFrameApplet(this, configuration);
            URL url = null;
            url = new URL(this.getUrlString());
            Phylogeny[] phys = Util.readPhylogeniesFromUrl(url, configuration.isValidatePhyloXmlAgainstSchema());
            Util.addPhylogeniesToTabs(phys, new File(url.getFile()).getName(), this.getUrlString(), this.getMainFrameApplet().getConfiguration(), this.getMainFrameApplet().getMainPanel());
            this.getMainFrameApplet().getMainPanel().getControlPanel().showWholeAll();
            this.getMainFrameApplet().getMainPanel().getControlPanel().showWhole();
            this.setVisible(true);
        }
        catch (Exception e) {
            ForesterUtil.printErrorMessage(NAME, e.toString());
            this.setBackground(ex_background_color);
            this.setForeground(ex_font_color);
            has_exception = true;
            this.setMessage1("Exception: " + e);
            e.printStackTrace();
            this.repaint();
        }
        if (!has_exception) {
            this.setMessage1("ArchaeopteryxA is now ready!");
            this.repaint();
            Util.printAppletMessage(NAME, "successfully initialized");
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        this.getMainFrameApplet().requestFocus();
        this.getMainFrameApplet().requestFocusInWindow();
        this.getMainFrameApplet().requestFocus();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(background_color);
        g.fillRect(0, 0, 300, 60);
        g.setColor(font_color);
        g.drawString(this.getMessage2(), 10, 20);
        g.drawString(this.getMessage1(), 10, 40);
    }

    private void setMessage1(String message_1) {
        this._message_1 = message_1;
    }

    private void setMessage2(String message_2) {
        this._message_2 = message_2;
    }

    private void setUrlString(String url_string) {
        this._url_string = url_string;
    }

    @Override
    public void start() {
        this.getMainFrameApplet().getMainPanel().validate();
        this.getMainFrameApplet().requestFocus();
        this.getMainFrameApplet().requestFocusInWindow();
        this.getMainFrameApplet().requestFocus();
        Util.printAppletMessage(NAME, "started");
    }
}

